// Getting, claming and using resources
// with DriverWorks.

// Using the registry with Driver::Works
// Note Driver::Works has it's own way of defining devices in
// the registry. The advantage of using there model is that
// you can use the KConfigurationQuery class and CreateRegistryPath
m_RegPath = KDevice::CreateRegistryPath(L"MyDevice",m_Unit);

KRegistryKey unitKey(*m_RegPath); 
    
if (NT_SUCCESS(unitKey.LastError()))
{	
    unitKey.QueryValue(L"PortBase", &m_PortBase);
    unitKey.QueryValue(L"PortRange", &m_PortRange);        
    unitKey.QueryValue(L"Irq", &m_Irq);
}

// Claming resources with Driver::Works
KResourceRequest resReq(Isa,0,0);

resReq.AddPort(m_PortBase,m_PortBase,m_PortRange,2,0,CmResourceShareDeviceExclusive);
resReq.AddIrq(m_Irq,m_Irq);   
resReq.Submit(this,m_DriverRegPath);

// Accessing the I/O ports using Driver::Works
KIoRange m_Ports;

// BusType, Offset, I/O port base, I/O port range
fStatus = m_Ports.Initialize(Isa,0,m_PortBase,m_PortRange);
// Write to the port
m_Ports.outb(RESET_ALL,0);

// Map an interrupt with Driver::Works
KInterrupt m_Interrupt;

// Setup the interrupt
m_Interrupt.Initialize(
    Isa,
    0,
    m_Irq,
    m_Irq,
    Latched,
    FALSE,
    FALSE
    );
    
// The Isr can be a member of the device class, it can also be an static
// member function to avoid the overhead of an extra function call.
m_Interrupt.Connect(LinkTo(Isr),this);

// Initialize a DPC object which may be queued by the interrupt service routine
InitializeDpcForIsr(LinkTo(DpcForIsr));

// Release claimed resources
KResourceRequest resReq(Isa,0,0);
		
resReq.Release(this,m_DriverRegPath);

// The destructor unmaps the memory automatically