#include <stdio.h>
#include <windows.h>
#include <winioctl.h>
#include <process.h>
#include "..\include\DD_CtlCode.h"

typedef struct
{
	HANDLE		hDevice;
	int			freq;	
} 
THREAD_BUFFER;

void OutputThread(LPVOID lpvThreadParam)
{
	BOOL			fStatus;
	DATA_BUFFER		db;
	OVERLAPPED		ov;
	DWORD			dwBytesRead;
	BOOL			fFirstTime = TRUE;
	long			nTotalSamples = 0;
	__int64			startTime,nSamples = 0;	
	THREAD_BUFFER	tb = *static_cast<THREAD_BUFFER *>(lpvThreadParam);

	ZeroMemory(&ov,sizeof(OVERLAPPED));	
	ov.hEvent = CreateEvent(NULL,TRUE,FALSE,NULL);
	
	while (TRUE)
	{	
		ov.Offset = ov.OffsetHigh = 0;	
		fStatus = ReadFile(
			tb.hDevice,
			&db,
			sizeof(db),
			&dwBytesRead,
			&ov
		    );
		if (fStatus == FALSE && GetLastError() != ERROR_IO_PENDING)
		{
			continue;			
		}		
		fStatus = GetOverlappedResult(tb.hDevice,&ov,&dwBytesRead,TRUE);
		if (dwBytesRead != sizeof(DATA_BUFFER))
		{
			printf("%d != %d\n",dwBytesRead,sizeof(DATA_BUFFER));
		}
		if (fStatus == TRUE)
		{			
			if (fFirstTime == TRUE)
			{			
				fFirstTime = FALSE;				
				startTime = db.timeStamp;
			}
			else
			{
				if ((nTotalSamples % 1) == 0)
				{
					printf("1:%d\t6:%d\t7:%d\t8:%d\n",db.data[0],db.data[5],db.data[6],db.data[7]);
				}
				if (db.timeStamp != 0)
				{
					if (tb.freq != nSamples)
					{
						printf("Freq = %d, nSamples = %I64d\n",tb.freq,nSamples);
					}
					nSamples = 0;
				}
			}
			nSamples++;												
			nTotalSamples++;
		}	 
		else
		{
			fFirstTime == TRUE;						
		}
	}
}

int main(void)
{		
	OVERLAPPED	ov;
	HANDLE		hDevice;
	BOOLEAN		fStatus;
	HANDLE		hThread = 0;
		        
	ZeroMemory(&ov,sizeof(OVERLAPPED));	
	// Create a handle to the driver
	hDevice = CreateFile("\\\\.\\DataDriverDevice0",
		GENERIC_READ | GENERIC_WRITE,
		FILE_SHARE_READ,
		NULL,
		OPEN_EXISTING,
		FILE_FLAG_OVERLAPPED,
		NULL
        );
	if (hDevice == INVALID_HANDLE_VALUE)
	{
		printf("TestHarness: CreateFile returns %0x\n",GetLastError());
		exit(1);
	}
    __try
    {                        
        DWORD dwBytesRead;
    
        // Setup overlapped structure            
    	ov.hEvent = CreateEvent(NULL,TRUE,FALSE,NULL);    	
    
        // Configure the device
    	DEVICE_CONFIGURATION dc;
    
        // Sample four channels at ten hertz
    	lstrcpy(dc.channelMap,"1000011100000000");
    	dc.freq = 10;
                	
    	DeviceIoControl(
    		hDevice,
    		IOCTL_DATADRIVER_SETUP,
    		&dc,
    		sizeof(DEVICE_CONFIGURATION),
    		NULL,
    		0,
    		NULL,
    		&ov
    		);
        fStatus = GetOverlappedResult(hDevice,&ov,&dwBytesRead,TRUE);            
    	if (fStatus == FALSE)
    	{
    		printf("TestHarness: DeviceIoControl returns %0x\n",GetLastError());
    		exit(1);
    	}
        // Start the read thread
    	THREAD_BUFFER tb = {hDevice,dc.freq};
            
	    hThread = (HANDLE)_beginthread(
    		OutputThread,
    		0,					   
    		&tb 
    		);
	    Sleep(500);    
    	// Start sampling
    
	    for (int i = 0;i < 5;i++)
    	{
    		printf("Calling Start device\n");    
    		ov.Offset = ov.OffsetHigh = 0;	            
    		DeviceIoControl(
    			hDevice,
    			IOCTL_DATADRIVER_START,
    			NULL,
    			0,
    			NULL,
    			0,
    			NULL,
    			&ov
    			);		
	    	fStatus = GetOverlappedResult(hDevice,&ov,&dwBytesRead,TRUE);
    		if (fStatus == FALSE)
    		{			
    			printf("TestHarness: DeviceIoControl returns %0x\n",GetLastError());
    			exit(1);
    		}
    		printf("TestHarness: Starting data aqusition at %dHz\n",dc.freq);		
    		Sleep(5000);
    		ov.Offset = ov.OffsetHigh = 0;
    		DeviceIoControl(
    			hDevice,
    			IOCTL_DATADRIVER_STOP,
    			NULL,
    		    0,
    			NULL,
    			0,
    			NULL,
    			&ov
    			);
	    	fStatus = GetOverlappedResult(hDevice,&ov,&dwBytesRead,TRUE);
    		if (fStatus == FALSE)
    		{
    			printf("TestHarness: DeviceIoControl returns %0x\n",GetLastError());
    			exit(1);
    		}
    		printf("TestHarness: The device is stopped\n");
    		Sleep(5000);            
    	}
	}
    __finally
    {
        if (hDevice != INVALID_HANDLE_VALUE)
            CloseHandle(hDevice);
        if (hThread != NULL)
        	CloseHandle(hThread);
        if (ov.hEvent != NULL)            
            CloseHandle(ov.hEvent);
    }        
	return 0;
}
