#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <err.h>
#include <signal.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/pioctl.h>
#include <machine/reg.h>
#include <machine/psl.h>

static int fd = -1;
static int cpid = -1;
extern int Procfd;

extern FILE *outfile;
#include "syscalls.c"

static int nsyscalls = sizeof(syscallnames) / sizeof(syscallnames[0]);

void
i386_syscall_entry(int pid, int nargs) {
  char buf[32];
  struct reg regs = { 0 };
  int syscall;
  int i;
  int memfd;

  if (fd == -1 || pid != cpid) {
    sprintf(buf, "/proc/%d/regs", pid);
    fd = open(buf, O_RDWR);
    if (fd == -1) {
      fprintf(outfile, "-- CANNOT READ REGISTERS --\n");
      return;
    }
    cpid = pid;
  }

  lseek(fd, 0L, 0);
  i = read(fd, &regs, sizeof(regs));
  syscall = regs.r_eax;

  if (syscall < 0 || syscall > nsyscalls) {
    fprintf(outfile, "-- UNKNOWN SYSCALL %d --\n", syscall);
  } else {
    fprintf (outfile, "SYSCALL %s\n", syscallnames[syscall]);
  }

  if (nargs == 0)
    return;

  lseek(Procfd, regs.r_esp + sizeof(int), SEEK_SET);

  for (i = 1; i < nargs; i++) {
    unsigned int arg;
    read(Procfd, &arg, sizeof(arg));
    fprintf(outfile, " 0x%x", arg);
  }

  fprintf(outfile, "\n");

  return;
}

void
i386_syscall_exit(int pid, int syscall) {
  char buf[32];
  struct reg regs;
  int retval;

  if (fd == -1 || pid != cpid) {
    sprintf(buf, "/proc/%d/regs", pid);
    fd = open(buf, O_RDONLY);
    if (fd == -1) {
      fprintf(outfile, "-- CANNOT READ REGISTERS --\n");
      return;
    }
    cpid = pid;
  }
  lseek(fd, 0L, 0);
  read(fd, &regs, sizeof(regs));
  retval = regs.r_eax;

  if (regs.r_eflags & PSL_C) {
    fprintf (outfile, "\terrno %d '%s'\n", retval, strerror(retval));
  } else 
    fprintf (outfile, "\treturns 0x%x (%d)\n", retval, retval);
  return;
}
