#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <err.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <sys/pioctl.h>

int
setup_and_wait(char *command[]) {
  struct procfs_status pfs;
  char buf[32];
  int fd;
  int pid;
  extern char *prog;

  pid = vfork();
  if (pid == -1) {
    err(1, "vfork failed\n");
  }
  if (pid == 0) {	/* Child */
    int mask = S_EXEC | S_EXIT;
    fd = open("/proc/curproc/mem", O_WRONLY);
    if (fd == -1)
      err(2, "cannot open /proc/curproc/mem: %s\n", strerror(errno));
    if (ioctl(fd, PIOCBIS, &mask) == -1)
      err(3, "PIOCBIS: %s\n", strerror(errno));
    execvp(command[0], command);
    err(4, "execvp %s: %s\n", command[0], strerror(errno));
  }
  /* Only in the parent here */

  sprintf(buf, "/proc/%d/mem", pid);
  if ((fd = open(buf, O_RDWR)) == -1)
    err(5, "cannot open %s:  %s\n", buf, strerror(errno));
  if (ioctl(fd, PIOCWAIT, &pfs) == -1)
    err(6, "PIOCWAIT: %s\n", strerror(errno));
  fprintf(stderr, "setup_and_wait:  pfs.why = %d\n", pfs.why);
  if (pfs.why == S_EXIT) {
    int zero = 0;
    fprintf(stderr, "process exited before exec'ing\n");
    ioctl(fd, PIOCCONT, &zero);
    wait(0);
    exit(7);
  }
  close(fd);
  return pid;
}

int
start_tracing(int pid, int flags) {
  int fd;
  char buf[32];

  sprintf(buf, "/proc/%d/mem", pid);
  fd = open(buf, O_RDWR);
  if (fd == -1)
    err(8, "cannot open %s", buf);

  if (ioctl(fd, PIOCBIS, &flags) == -1)
    err(9, "cannot set procfs event bit mask");

  return fd;
}
