	page	60,132
;-----------------------------------------------------------------------------
;
; FOOFBUG.ASM	  Copyright (c) 1998  Robert Collins
;
;       You have my permission to copy and distribute this software for
;       non-commercial purposes.  Any commercial use of this software or
;       source code is allowed, so long as the appropriate copyright
;       attributions (to me) are intact, *AND* my email address is properly
;       displayed.
;
;       Basically, give me credit, where credit is due, and show my email
;       address.
;
;-----------------------------------------------------------------------------
;
;	Robert R. Collins		email:	rcollins@x86.org
;
;-----------------------------------------------------------------------------


;-----------------------------------------------------------------------------
; Assembler directives
;-----------------------------------------------------------------------------
	.xlist			; disable list file
	.586P
	.ALPHA


;-----------------------------------------------------------------------------
; Include file section
;-----------------------------------------------------------------------------
%	Include INCLUDEDIR\\macros.inc	; Include macros
%	Include INCLUDEDIR\\struct.inc	; Include structures


;-----------------------------------------------------------------------------
; Public declarations
;-----------------------------------------------------------------------------
	Public	GDT_PTR,	ext_mem_blocks


;-----------------------------------------------------------------------------
; External declarations
;-----------------------------------------------------------------------------
	Extern	Init4M_Pages		:	Near16
	Extern	GetLinear4M		:	Near16
	Extern	GetPDBR 		:	Near16
	Extern	PDBR			:	DWord


;-----------------------------------------------------------------------------
; Equates & macros
;-----------------------------------------------------------------------------


	.list
;-----------------------------------------------------------------------------
; Dummy segments
;-----------------------------------------------------------------------------
        INTSEG  segment at 0
        int0    dd      ?
	int1	dd	?
	int2	dd	?
	int3	dd	?
	int4	dd	?
	int5	dd	?
	int6	dd	?
        INTSEG  ends


	_DATA segment para public use16 'DATA'
;-----------------------------------------------------------------------------
; Data segment
;-----------------------------------------------------------------------------
	GDT_386 label	fword
	GDT_PTR 	Descriptor	<>
	SEL_RMCS	equ	$-GDT_386
	GDT_RMCS	Descriptor	<-1,,,9bh,0,>	; DS Descriptor
	SEL_RMDS	equ	$-GDT_386
	GDT_RMDS	Descriptor	<-1,,,93h,0,>	; DS Descriptor
	SEL_PGDIR	equ	$-GDT_386
	GDT_PGDIR	Descriptor	<-1,,,93h,0,>	; DS Descriptor
	SEL_RMSS	equ	$-GDT_386
	GDT_RMSS	Descriptor	<-1,,,93h,0,>	; SS Descriptor
	SEL_4G		equ		$-GDT_386
	GDT_4G		Descriptor	<-1h,0,0h,93h,8fh,0h>	   ; 4G Descriptor
	GDT_Len 	equ	($-GDT_386) - 1


;-----------------------------------------------------------------------------
; Reference data
;-----------------------------------------------------------------------------
	INT00_EFLAGS_Ref	dd	5 dup (0)
	INT01_EFLAGS_Ref0	dd	5 dup (0)
	INT01_EFLAGS_Ref1	dd	5 dup (0)
	INT01_EFLAGS_Ref2	dd	5 dup (0)
	INT03_EFLAGS_Ref	dd	5 dup (0)
	INT04_EFLAGS_Ref	dd	5 dup (0)
	INT05_EFLAGS_Ref	dd	5 dup (0)
	INT06_EFLAGS_Ref	dd	5 dup (0)


;-----------------------------------------------------------------------------
; All other data
;-----------------------------------------------------------------------------
	PassMsg 	db	"All tests passed",CRLF$
	FailMsg 	db	"Some tests failed:  $"

	ext_mem_blocks	dw	0
	OrigCR0 	dd	0
	BoundLimit	dw	20h
			dw	20h

	align
	RM_IDT3_Ptr	dw	256*4
			dd	0
			dw	0
	IDT3_Ptr	label	Descriptor
			dw	IDT3_Len-1
			dd	0
			dw	0

	_DATA	ENDS

	IDT_RELOSEG	segment at 6000h
	IDT_RELOSEG	ends

	IDTSEG		segment para public use16 'DATA'
	org		1000h - (7 * Sizeof(INT_Desc))
	IDesc		equ	(INT_Desc ptr gs:[eax])
;-----------------------------------------------------------------------------
; Interrupt descriptor table
;-----------------------------------------------------------------------------
	IDT_386 INT_Desc	<Offset INT00,SEL_RMCS,0>    ; INT00
		INT_Desc	<Offset INT01,SEL_RMCS,0>    ; INT01
		INT_Desc	<Offset INT02,SEL_RMCS,0>    ; INT02
		INT_Desc	<Offset INT03,SEL_RMCS,0>    ; INT03
		INT_Desc	<Offset INT04,SEL_RMCS,0>    ; INT04
		INT_Desc	<Offset INT05,SEL_RMCS,0>    ; INT05
		INT_Desc	<Offset INT06,SEL_RMCS,0>    ; INT06
		INT_Desc	<Offset INT07,SEL_RMCS,0>    ; INT07
		INT_Desc	<Offset INT08,SEL_RMCS,0>    ; INT08
		INT_Desc	<Offset INT09,SEL_RMCS,0>    ; INT09
		INT_Desc	<Offset INT0a,SEL_RMCS,0>    ; INT0a
		INT_Desc	<Offset INT0b,SEL_RMCS,0>    ; INT0b
		INT_Desc	<Offset INT0c,SEL_RMCS,0>    ; INT0c
		INT_Desc	<Offset INT0d,SEL_RMCS,0>    ; INT0d
		INT_Desc	<Offset INT0e,SEL_RMCS,0>    ; INT0e
		INT_Desc	<Offset INT0f,SEL_RMCS,0>    ; INT0f
		INT_Desc	<Offset INT10,SEL_RMCS,0>    ; INT10
		INT_Desc	<Offset INT11,SEL_RMCS,0>    ; INT11
		INT_Desc	<Offset INT12,SEL_RMCS,0>    ; INT12
		INT_Desc	<Offset INT13,SEL_RMCS,0>    ; INT13
		INT_Desc	<Offset INT14,SEL_RMCS,0>    ; INT14
		INT_Desc	<Offset INT15,SEL_RMCS,0>    ; INT15
		INT_Desc	<Offset INT16,SEL_RMCS,0>    ; INT16
		INT_Desc	<Offset INT17,SEL_RMCS,0>    ; INT17
		INT_Desc	<Offset INT18,SEL_RMCS,0>    ; INT18
		INT_Desc	<Offset INT19,SEL_RMCS,0>    ; INT19
		INT_Desc	<Offset INT1a,SEL_RMCS,0>    ; INT1a
		INT_Desc	<Offset INT1b,SEL_RMCS,0>    ; INT1b
		INT_Desc	<Offset INT1c,SEL_RMCS,0>    ; INT1c
		INT_Desc	<Offset INT1d,SEL_RMCS,0>    ; INT1d
		INT_Desc	<Offset INT1e,SEL_RMCS,0>    ; INT1e
		INT_Desc	<Offset INT1f,SEL_RMCS,0>    ; INT1f
	IDT3_Len	equ	$-IDT_386
		org	2000h
	IDTSEG	ENDS



	_TEXT	segment para public use16 'CODE'
	ASSUME	CS:_TEXT, DS:_DATA, ES:_DATA, SS:STACK

;-----------------------------------------------------------------------------
; Code starts here
;-----------------------------------------------------------------------------
	SMM_Test	proc	far
	mov	ax,seg STACK		; setup stack segment
	mov	ss,ax
	mov	sp,sizeof StackPtr
	xor	ax,ax			; clear it
	pushf
	push	ds			; save far return on stack
	push	ax

;-----------------------------------------------------------------------------
; Set segments to normal data segment
;-----------------------------------------------------------------------------
	mov	ax,seg _DATA		; get original data segment
	mov	ds,ax
	mov	es,ax

;-----------------------------------------------------------------------------
; Setup descriptor table
;-----------------------------------------------------------------------------
	mov	eax,ds			; make pointer to GDT table
	shl	eax,4			; have physical address of segment
	add	eax,offset GDT_386	; now have physical addr of table
	mov	GDT_PTR.Seg_limit,GDT_Len	; set length
	mov	GDT_PTR.Base_A15_A00,ax
	shr	eax,10h 		; get other address bits
	mov	GDT_PTR.Base_A23_A16,al
	mov	GDT_PTR.Access_rights,ah

	mov	eax,seg IDT_RELOSEG	; make pointer to IDT table
	shl	eax,4			; have physical address of segment
	add	eax,offset IDT_386	; now have physical addr of table
	mov	dword ptr Idt3_Ptr[2],eax

	mov	eax,cs			; get CS
	shl	eax,4			; now have physical address
	mov	GDT_RMCS.Base_A15_A00,ax
	shr	eax,10h 		; get other address bits
	mov	GDT_RMCS.Base_A23_A16,al
	mov	GDT_RMCS.Base_A31_A24,ah

	mov	eax,ds			; get DS
	shl	eax,4			; now have physical address
	mov	GDT_RMDS.Base_A15_A00,ax
	shr	eax,10h 		; get other address bits
	mov	GDT_RMDS.Base_A23_A16,al
	mov	GDT_RMDS.Base_A31_A24,ah

	mov	eax,ss			; get SS
	shl	eax,4			; now have physical address
	mov	GDT_RMSS.Base_A15_A00,ax
	shr	eax,10h 		; get other address bits
	mov	GDT_RMSS.Base_A23_A16,al
	mov	GDT_RMSS.Base_A31_A24,ah

;-----------------------------------------------------------------------------
; Find location of CR3 register
;-----------------------------------------------------------------------------
	call	GetPDBR 		; get address of page directory
	jnc	@F			; no oops

@ErrorExit:
	mov	ah,9
	int	21h			; print message
	mov	ax,4c01h		; set error code
	int	21h
	iret				; go split, just in case

@@:	mov	PDBR,edx		; save it

;-----------------------------------------------------------------------------
; Get the amount of extended memory.
;-----------------------------------------------------------------------------
	mov	al,18h
	out	70h,al
	IO_Delay
	in	al,71h
	mov	ah,al
	mov	al,17h
	out	70h,al
	IO_Delay
	in	al,71h
	shr	ax,6
	mov	ext_mem_blocks,ax

;-----------------------------------------------------------------------------
; Enter protected mode
;-----------------------------------------------------------------------------
	cli
	lgdt	GDT_386
	Lidt	fword ptr IDT3_Ptr
	mov	eax,cr0 		; get control register
	mov	OrigCR0,eax		; save it
	or	eax,60000001h		; disable cache & enable PM
	mov	cr0,eax
	wbinvd				; invalidate the cache
	push	cs			; push return selector on stack
	push	offset PMRET		; set return offset
	JMPFAR	@F,SEL_RMCS

;-----------------------------------------------------------------------------
; Initialize some segment
;-----------------------------------------------------------------------------
@@:	mov	ax,SEL_RMDS		; get DS selector
	mov	ds,ax
	mov	ax,SEL_4G		; get GS selector
	mov	gs,ax
	mov	es,ax

;-----------------------------------------------------------------------------
; Relocate the IDT
;-----------------------------------------------------------------------------
	mov	esi,seg IDTSEG		; get segment paragraph
	shl	esi,4			; make physical address
	add	esi,offset IDT_386	; now have full physical address
	mov	edi,seg IDT_RELOSEG	; get segment paragraph
	shl	edi,4			; make physical address
	add	edi,offset IDT_386	; now have full physical address
	mov	ecx,IDT3_Len		; get IDT length
	rep	movs byte ptr es:[edi], byte ptr gs:[esi]

;-----------------------------------------------------------------------------
; Initialize remaining segment
;-----------------------------------------------------------------------------
	mov	ax,SEL_PGDIR		; get ES selector
	mov	es,ax
	mov	ax,SEL_RMSS		; get SS selector
	mov	ss,ax

;-----------------------------------------------------------------------------
; Enable page mode
;-----------------------------------------------------------------------------
	call	Init4M_Pages
	mov	ebx,PDBR		; initialize CR3
	mov	cr3,ebx
	mov	ebx,cr4 		; get CR4
	or	bx,PSE			; enable 4M pages
	mov	cr4,ebx
	mov	ebx,cr0 		; get 386 control register
	or	ebx,80000000h		; set PG bit
	mov	cr0,ebx 		; now we're in protected mode
	jmp	short @F

;-----------------------------------------------------------------------------
; Now in paging mode
;-----------------------------------------------------------------------------
; Fix 1:  Cache OFF
;-----------------------------------------------------------------------------
@@:	mov	al,7Eh			; value to trigger my logic analyzer
	out	0b2h,al 		; trigger my logic analyzer
	mov	ebp,0			; index into table
	call	GenerateExceptions	; Go generate the Exceptions

;-----------------------------------------------------------------------------
; Fix 2:  Map the first six entries in the IDT in a not-present page
;-----------------------------------------------------------------------------
	invd				; invalidate the cache
	mov	eax,cr0 		; get CR0
	and	eax,not 60000000h	; enable the cache
	mov	cr0,eax 		; cache now on.
	mov	edx,SEL_4G		; get selector
	mov	eax,seg IDT_RELOSEG	; get IDT segment
	shl	eax,4			; make physical address
	add	eax,offset IDT_386	; get base of IDT
	call	GetLinear4M		; get page dir/table entries
	and	byte ptr gs:[eax],not 1 ; clear Present bit
	mov	eax,cr3 		; flush the TLB
	mov	cr3,eax 		; TLB now flushed
	mov	ebp,4			; index into table
	call	GenerateExceptions	; Go generate the Exceptions

;-----------------------------------------------------------------------------
; Fix 3:  Map the first six entries in the IDT in a read-only page w/ CR0.WP=1
;-----------------------------------------------------------------------------
	mov	edx,SEL_4G		; get selector
	mov	eax,seg IDT_RELOSEG	; get IDT segment
	shl	eax,4			; make physical address
	add	eax,offset IDT_386	; get base of IDT
	call	GetLinear4M		; get page dir/table entries
	or	byte ptr gs:[eax],1	; clear Present bit
	push	eax			; save page table address pointer
	mov	eax,cr3 		; flush the TLB
	mov	cr3,eax 		; TLB now flushed
	mov	edx,SEL_4G		; get selector
	mov	eax,seg IDT_RELOSEG	; get IDT segment
	shl	eax,4			; make physical address
	add	eax,offset IDT_386[0eh*8]; now have page fault handler pointer
	mov	IDesc.IGate_OffsetLO, offset int0e_2	; point to next handler
	pop	eax			; restore page table pointer
	and	byte ptr gs:[eax],not 2 ; set read-only page
	mov	eax,cr3 		; flush the TLB
	mov	cr3,eax 		; TLB now flushed
	mov	eax,cr0 		; get CR0
	or	eax,10000h		; set CR0.WP=1
	mov	cr0,eax 		; now CR0.WP=1
	mov	ebp,8			; index into table
	call	GenerateExceptions	; Go generate the Exceptions

;-----------------------------------------------------------------------------
; Fix 4:  Map the first six entries in the IDT in a non-cacheable page
;-----------------------------------------------------------------------------
	mov	eax,cr0 		; get CR0
	and	eax,not 10000h		; clear CR0.WP=0
	mov	cr0,eax 		; now CR0.WP=0
	mov	edx,SEL_4G		; get selector
	mov	eax,seg IDT_RELOSEG	; get IDT segment
	shl	eax,4			; make physical address
	add	eax,offset IDT_386	; get base of IDT
	call	GetLinear4M		; get page dir/table entries
	or	byte ptr gs:[eax],12h	; set non-cacheable, read/write page
	mov	eax,cr3 		; flush the TLB
	mov	cr3,eax 		; TLB now flushed
	mov	edx,SEL_4G		; get selector
	mov	eax,seg IDT_RELOSEG	; get IDT segment
	shl	eax,4			; make physical address
	add	eax,offset IDT_386[0eh*8]; now have page fault handler pointer
	mov	IDesc.IGate_OffsetLO, offset int0e_3	; point to next handler
	mov	ebp,0ch 		; index into table
	call	GenerateExceptions	; Go generate the Exceptions

;-----------------------------------------------------------------------------
; Fix 5:  Map the first six entries in the IDT in a cacheable,
;	  but write-through page
;-----------------------------------------------------------------------------
	mov	eax,cr0 		; get CR0
	and	eax,not 10000h		; clear CR0.WP=0
	mov	cr0,eax 		; now CR0.WP=0
	mov	edx,SEL_4G		; get selector
	mov	eax,seg IDT_RELOSEG	; get IDT segment
	shl	eax,4			; make physical address
	add	eax,offset IDT_386	; get base of IDT
	call	GetLinear4M		; get page dir/table entries
	and	byte ptr gs:[eax],not 10h; turn off PCD
	or	byte ptr gs:[eax],08h	; set non-cacheable, read/write page
	mov	eax,cr3 		; flush the TLB
	mov	cr3,eax 		; TLB now flushed
	mov	edx,SEL_4G		; get selector
	mov	eax,seg IDT_RELOSEG	; get IDT segment
	shl	eax,4			; make physical address
	add	eax,offset IDT_386[0eh*8]; now have page fault handler pointer
	mov	IDesc.IGate_OffsetLO, offset int0e_3	; point to next handler
	mov	ebp,10h 		; index into table
	call	GenerateExceptions	; Go generate the Exceptions

;-----------------------------------------------------------------------------
; Split from this program
;-----------------------------------------------------------------------------
@Split:
@@:	lidt	ds:fword ptr RM_IDT3_Ptr
	invd				; invalidate the cache
	mov	eax,OrigCR0		; get original CR0
	mov	cr0,eax 		;   and store in CR0
	mov	edx,cr4 		; get PSE
	and	dl,not PSE		; turn off PSE
	mov	cr4,edx
	mov	edx,cr3 		; clear TLB by loading
	mov	cr3,edx 		;  CR3 with any value
	retf

PMRET:
	mov	ax,seg _DATA
	mov	ds,ax
	mov	es,ax
	mov	gs,ax
	mov	ax,seg STACK
	mov	ss,ax

;-----------------------------------------------------------------------------
; Now print the results
;-----------------------------------------------------------------------------
	iret				; return to DOS
	SMM_Test	endp


;-----------------------------------------------------------------------------
  GenerateExceptions	proc	near
;-----------------------------------------------------------------------------
; Exception 0:	DIVIDE BY 0
;-----------------------------------------------------------------------------
	wbinvd				; flush the cache
	lea	ebx,INT00_EFLAGS_Ref[ebp]
	mov	edx,offset @F		; set resume address
	xor	eax,eax 		; set reference EFLAGS contents
	push	eax
	popfd
	idiv	ax			; Divide by 0 to generate a fault

;-----------------------------------------------------------------------------
; Exception 1:	ICEBP
;-----------------------------------------------------------------------------
@@:	wbinvd				; flush the cache
	mov	ecx,8000001Dh		; undocumented MSR to turn off ICEBP
	rdmsr				; get current ICEBP status
	push	eax			; save current status
	push	edx			;  "
	push	ecx			; save MSR number
	and	al,not 1		; turn off ICEBP
	wrmsr				; now ICEBP is turned off
	lea	ebx,INT01_EFLAGS_Ref0[ebp]
	mov	edx,offset @F
	xor	eax,eax 		; set reference EFLAGS contents
	push	eax
	popfd
	ICEBP

;-----------------------------------------------------------------------------
; Exception 1:	Instruction breakpoint
;-----------------------------------------------------------------------------
@@:	wbinvd				; flush the cache
	mov	eax,seg _TEXT		; get current code segment
	shl	eax,4			; make into physical segment
	add	eax,offset @IBP 	;
	mov	dr0,eax 		; set breakpoint address
	mov	eax,00000002h		; set global breakpoint for INSTRUCTION
	mov	dr7,eax 		;
	lea	ebx,INT01_EFLAGS_Ref1[ebp]
	mov	edx,offset @F
	xor	eax,eax 		; set reference EFLAGS contents
	push	eax
	popfd
@IBP:	nop				; this should cause a breakpoint event

;-----------------------------------------------------------------------------
; Exception 1:	Data breakpoint
;-----------------------------------------------------------------------------
@@:	wbinvd				; flush the cache
	mov	eax,80000h		; get physical address
	mov	dr0,eax 		; set breakpoint address
	mov	eax,000F0002h		; set global breakpoint for DATA
	mov	dr7,eax 		;
	lea	ebx,INT01_EFLAGS_Ref2[ebp]
	mov	edx,offset @F
	xor	eax,eax 		; set reference EFLAGS contents
	push	eax
	popfd
	mov	ecx,1000h		; set loop count
	mov	eax,gs:[80000h] 	; try to gather data
	loop	$
@@:	pop	ecx			; get MSR value
	pop	edx
	pop	eax
	wrmsr				; restore ICEBP status

;-----------------------------------------------------------------------------
; Exception 3:	Breakpoint interrupt
;-----------------------------------------------------------------------------
	wbinvd				; flush the cache
	lea	ebx,INT03_EFLAGS_Ref[ebp]
	mov	edx,offset @F
	xor	eax,eax 		; set reference EFLAGS contents
	push	eax
	popfd
	int	3			; breakpoint interrupt

;-----------------------------------------------------------------------------
; Exception 4:	Interrupt on Overflow
;-----------------------------------------------------------------------------
@@:	wbinvd				; flush the cache
	lea	ebx,INT04_EFLAGS_Ref[ebp]
	mov	edx,offset @F
	mov	eax,800h		; set reference EFLAGS contents (OF=1)
	push	eax
	popfd
	into				; interrupt on overflow

;-----------------------------------------------------------------------------
; Exception 5:	Bound exception
;-----------------------------------------------------------------------------
@@:	wbinvd				; flush the cache
	lea	ebx,INT05_EFLAGS_Ref[ebp]
	mov	edx,offset @F
	mov	ax,20h
	mov	BoundLimit,ax
	mov	BoundLimit[2],ax
	xor	eax,eax 		; set reference EFLAGS contents
	push	eax
	popfd
	bound	ax,BoundLimit		; bound exception

;-----------------------------------------------------------------------------
; Exception 6:	The FOOF bug
;-----------------------------------------------------------------------------
@@:	mov	al,7Eh			; value to trigger my logic analyzer
	out	0b2h,al 		; trigger my logic analyzer
	wbinvd				; flush the cache
	lea	ebx,INT06_EFLAGS_Ref[ebp]
	mov	edx,offset @F
	xor	eax,eax 		; set reference EFLAGS contents
	push	eax
	popfd
	db	0f0h, 00fh, 0c7h, 0c8h	; LOCK CMPXCHG8B EAX
@@:
	ret
GenerateExceptions	endp


;-----------------------------------------------------------------------------
; HEX_STRING:	Convert a string of 8-bit hex numbers to ASCII.
; Input:   DS:SI = Pointer to hex data
;	   ES:DI = Buffer to get output
;	   CX	 = # of bytes to convert
; Output:  ES:DI = Filled in w/ ASCII hex#
; Register(s) modified:  CX
;-----------------------------------------------------------------------------
  Hex_String	proc	near
;-----------------------------------------------------------------------------
	jcxz	@Hex_str_exit		; go split
	push	ax			; [bp][0ah]
	push	cx			; [bp][8]
	push	dx			; [bp][6]
	push	si			; [bp][4]
	push	di			; [bp][2]
	push	bp			; [bp]
	mov	bp,sp
	add	si,cx

@@:	dec	si
	mov	al,ds:[si]		; get hex digit
	mov	dl,al
	mov	cl,4			; shift count
	rol	dl,cl
	mov	al,dl			; save it
	and	al,0fh			; keep low nibble
	daa
	add	al,0f0h
	adc	al,40h			; here is the ASCII
	stosb				; save it
	mov	cl,4			; shift count
	rol	dl,cl
	mov	al,dl			; save it
	and	al,0fh			; keep low nibble
	daa
	add	al,0f0h
	adc	al,40h			; here is the ASCII
	stosb				; save it
	dec	word ptr [bp][8]	; are we done yet?
	jnz	@B
	pop	bp
	pop	di
	pop	si
	pop	dx
	pop	cx
	pop	ax

@Hex_str_exit:
	ret
Hex_String	endp


;-----------------------------------------------------------------------------
; Interrupt routines
;-----------------------------------------------------------------------------
	INT00	label	word
	mov	eax,[esp][8]		; get EFLAGS value from stack
	mov	[ebx],eax		; save EFLAGS value
	mov	[esp],edx		; save new EIP
	iretd

	INT01	label	word
	mov	eax,[esp][8]		; get EFLAGS value from stack
	mov	[ebx],eax		; save EFLAGS value
	mov	[esp],edx		; save new EIP
	xor	eax,eax 		; clear DR7 & DR6 & DR0
	mov	dr7,eax
	mov	dr6,eax
	mov	dr0,eax
	iretd

	INT02	label	word
	ICEBP
	push	ax
	mov	al,22h
	out	80h,al
	pop	ax
	iretd

	INT03	label	word
	mov	eax,[esp][8]		; get EFLAGS value from stack
	mov	[ebx],eax		; save EFLAGS value
	mov	[esp],edx		; save new EIP
	iretd

	INT04	label	word
	mov	eax,[esp][8]		; get EFLAGS value from stack
	mov	[ebx],eax		; save EFLAGS value
	mov	[esp],edx		; save new EIP
	iretd

	INT05	label	word
	mov	eax,[esp][8]		; get EFLAGS value from stack
	mov	[ebx],eax		; save EFLAGS value
	mov	[esp],edx		; save new EIP
	iretd

	INT06	label	word
	mov	eax,[esp][8]		; get EFLAGS value from stack
	mov	[ebx],eax		; save EFLAGS value
	mov	[esp],edx		; save new EIP
	iretd

	INT07	label	word
	ICEBP
	push	ax
	mov	al,27h
	out	80h,al
	pop	ax
	iret

	INT08	label	word
	ICEBP
	push	ax
	mov	al,28h
	out	80h,al
	pop	ax
	iret

	INT09	label	word
	ICEBP
	push	ax
	mov	al,29h
	out	80h,al
	pop	ax
	iret

	INT0a	label	word
	ICEBP
	push	ax
	mov	al,2ah
	out	80h,al
	pop	ax
	iret

	INT0b	label	word
	ICEBP
	push	ax
	mov	al,2bh
	out	80h,al
	pop	ax
	iret

	INT0c	label	word
	ICEBP
	push	ax
	mov	al,2ch
	out	80h,al
	pop	ax
	iret

;;;	INT0d	label	word
	INT0f	label	word
	ICEBP
	push	ax
	mov	al,2fh
	out	80h,al
	pop	ax
	iret

	INT10	label	word
	ICEBP
	push	ax
	mov	al,30h
	out	80h,al
	pop	ax
	iret

	INT11	label	word
	ICEBP
	push	ax
	mov	al,31h
	out	80h,al
	pop	ax
	iret

	INT12	label	word
	ICEBP
	push	ax
	mov	al,32h
	out	80h,al
	pop	ax
	iret

	INT13	label	word
	ICEBP
	push	ax
	mov	al,33h
	out	80h,al
	pop	ax
	iret

	INT14	label	word
	ICEBP
	push	ax
	mov	al,34h
	out	80h,al
	pop	ax
	iret

	INT15	label	word
	ICEBP
	push	ax
	mov	al,35h
	out	80h,al
	pop	ax
	iret

	INT16	label	word
	ICEBP
	push	ax
	mov	al,36h
	out	80h,al
	pop	ax
	iret

	INT17	label	word
	ICEBP
	push	ax
	mov	al,37h
	out	80h,al
	pop	ax
	iret

	INT18	label	word
	ICEBP
	push	ax
	mov	al,38h
	out	80h,al
	pop	ax
	iret

	INT19	label	word
	ICEBP
	push	ax
	mov	al,39h
	out	80h,al
	pop	ax
	iret

	INT1a	label	word
	ICEBP
	push	ax
	mov	al,3ah
	out	80h,al
	pop	ax
	iret

	INT1b	label	word
	ICEBP
	push	ax
	mov	al,3bh
	out	80h,al
	pop	ax
	iret

	INT1c	label	word
	ICEBP
	push	ax
	mov	al,3ch
	out	80h,al
	pop	ax
	iret

	INT1d	label	word
	ICEBP
	push	ax
	mov	al,3dh
	out	80h,al
	pop	ax
	iret

	INT1e	label	word
	ICEBP
	push	ax
	mov	al,3eh
	out	80h,al
	pop	ax
	iret

	INT1f	label	word
	ICEBP
	push	ax
	mov	al,3fh
	out	80h,al
	pop	ax
	iret

	INT0d	label	word
	ICEBP
	push	ax
	mov	al,2dh
	out	80h,al
	pop	ax
	or	eax,ebx 		; set results
	or	edx,ecx
	add	word ptr [esp][2],3
	add	sp,2			; point past error code
	iret

	INT0e	label	word
	add	sp,4			; ignore error code on stack image

	push	edx
	push	ebx			; save address
	mov	edx,SEL_4G		; get selector
	mov	eax,seg IDT_RELOSEG	; get IDT segment
	shl	eax,4			; make physical address
	add	eax,offset IDT_386	; get base of IDT
	call	GetLinear4M		; get page dir/table entries
	or	byte ptr gs:[eax],1	; mark Present bit
	mov	eax,cr3 		; flush the TLB
	mov	cr3,eax 		; TLB now flushed
	pop	ebx			; restore address
	pop	edx

	mov	eax,cr2 		; get page fault location
	mov	ecx,[esp][08h]		; get original EFLAGS value
	push	ecx
	movzx	ecx,IDesc.CSEG_Sel	; get segment selector
	push	ecx			;
	mov	cx,IDesc.IGate_OffsetHI
	shl	ecx,10h
	mov	cx,IDesc.IGate_OffsetLO
	push	ecx

	push	edx
	push	ebx			; save address
	mov	edx,SEL_4G		; get selector
	mov	eax,seg IDT_RELOSEG	; get IDT segment
	shl	eax,4			; make physical address
	add	eax,offset IDT_386	; get base of IDT
	call	GetLinear4M		; get page dir/table entries
	and	byte ptr gs:[eax],not 1 ; mark Present bit
	mov	eax,cr3 		; flush the TLB
	mov	cr3,eax 		; TLB now flushed
	pop	ebx			; restore address
	pop	edx
	iretd


	INT0e_2 label	word
	add	sp,4			; ignore error code on stack image
	mov	eax,cr2 		; get page fault location
	mov	ecx,[esp][08h]		; get original EFLAGS value
	push	ecx
	movzx	ecx,IDesc.CSEG_Sel	; get segment selector
	push	ecx			;
	mov	cx,IDesc.IGate_OffsetHI
	shl	ecx,10h
	mov	cx,IDesc.IGate_OffsetLO
	push	ecx
	iretd


	INT0e_3 label	word
	ICEBP
	iretd

_TEXT	ends


	STACK segment para public 'STACK'
;-----------------------------------------------------------------------------
; Stack segment
;-----------------------------------------------------------------------------
	StackPtr	db	400h dup (?)
	STACK	ends

	end	SMM_Test
