	page	60,132
;-----------------------------------------------------------------------------
;
; PAGEFNS.ASM	Copyright (c) 1995-Present Robert Collins
;
;       You have my permission to copy and distribute this software for
;       non-commercial purposes.  Any commercial use of this software or
;       source code is allowed, so long as the appropriate copyright
;       attributions (to me) are intact, *AND* my email address is properly
;       displayed.
;
;       Basically, give me credit, where credit is due, and show my email
;       address.
;
;-----------------------------------------------------------------------------
;
;	Robert R. Collins		email:	rcollins@x886.org
;
;-----------------------------------------------------------------------------


;-----------------------------------------------------------------------------
; Assembler directives
;-----------------------------------------------------------------------------
	.xlist			; disable list file
	.586P
	.ALPHA

;-----------------------------------------------------------------------------
; Include file section
;-----------------------------------------------------------------------------
%	Include INCLUDEDIR\\macros.inc	; Include macros
%	Include INCLUDEDIR\\struct.inc	; Include structures


;-----------------------------------------------------------------------------
; Public declarations
;-----------------------------------------------------------------------------
	Public	Init4M_Pages,	Init2M_Pages
	Public	Check4M_Pages,	Check2M_Pages
	Public	PG_Msg, 	PE_Msg
	Public	Not4M_Msg,	Not2M_Msg
	Public	GetLinear4M
	Public	GetPDBR,	PDBR


;-----------------------------------------------------------------------------
; External declarations
;-----------------------------------------------------------------------------
	Extern	ext_mem_blocks		:	Word
	Extern	GDT_PTR 		:	Descriptor


	.list
	_DATA segment para public use16 'DATA'
;-----------------------------------------------------------------------------
; Data segment
;-----------------------------------------------------------------------------
	PDBR		dd	0
	PG_Msg		db	"Can't run test...already in paging mode.",CRLF$
	PE_Msg		db	"Can't run test...already in protected mode.",CRLF$
	Not4M_Msg	db	"This processor doesn't support 4M pages.",CRLF$
	Not2M_Msg	db	"This processor doesn't support 2M pages.",CRLF$
	PageTblErr	db	"Can't allocate memory for page tables.",CRLF$

	_DATA	ENDS


	_TEXT	segment para public use16 'CODE'
	ASSUME	CS:_TEXT, DS:_DATA, ES:_DATA

	OBJ_PAGEFNS	label	word
	Public	OBJ_PAGEFNS

	IFDEF RRC
	ORG	2010h
	ENDIF

;-----------------------------------------------------------------------------
  Check4M_Pages 	proc	near	; Determine wether or not this
;					; processor supports 4M pages.	It is
;					; assumed this is being run on a
;					; Pentium-class processor.
;-----------------------------------------------------------------------------
; Input:   None
; Output:  DX = Address of error message if CY
;	   DX = Undefined in NC
;-----------------------------------------------------------------------------
; This algorithm uses an undocumented form of an instruction:  SMSW EAX.
; This instruction works on all Intel processors, but doesn't work on all
; clones.  So user beware.
;-----------------------------------------------------------------------------
	xor	eax,eax 		; clear it
	db	66h			; were're going to do something
	smsw	ax			;  undocumented here, don't look
	test	eax,80000001h		; page mode or pretected mode enabled?
	jz	@F			; nope, continue
	mov	dx,offset PG_Msg	;
	shl	eax,1			; check for PE
	jc	@ErrorExit1		; oops
	mov	dx,offset PE_Msg

@ErrorExit1:
	stc				; set carry flag
	ret				; go split

@@:	mov	eax,1			; get CPUID flags
	cpuid				;
	test	dx,1000y		; does this processor support 4M pages?
	mov	dx,offset Not4M_Msg	; set message for failure
	jz	@ErrorExit1		; nope, go split
	clc				; clear carry flag
	ret				; go split
Check4M_Pages	endp


;-----------------------------------------------------------------------------
  Check2M_Pages 	proc	near	; Determine wether or not this
;					; processor supports 2M pages.	It is
;					; assumed this is being run on a
;					; Pentium-class processor.
;-----------------------------------------------------------------------------
; Input:   None
; Output:  DX = Address of error message if CY
;	   DX = Undefined in NC
;-----------------------------------------------------------------------------
; This algorithm uses an undocumented form of an instruction:  SMSW EAX.
; This instruction works on all Intel processors, but doesn't work on all
; clones.  So user beware.
;-----------------------------------------------------------------------------
	xor	eax,eax 		; clear it
	db	66h			; were're going to do something
	smsw	ax			;  undocumented here, don't look
	test	eax,80000001h		; page mode or pretected mode enabled?
	jz	@F			; nope, continue
	mov	dx,offset PG_Msg	;
	shl	eax,1			; check for PE
	jc	@ErrorExit2		; oops
	mov	dx,offset PE_Msg

@ErrorExit2:
	stc				; set carry flag
	ret				; go split

@@:	mov	eax,1			; get CPUID flags
	cpuid				;
	test	dx,1000000y		; does this processor support 2M pages?
	mov	dx,offset Not2M_Msg	; set message for failure
	jz	@ErrorExit2		; nope, go split
	clc				; clear carry flag
	ret				; go split
Check2M_Pages	endp


;-----------------------------------------------------------------------------
  Init4M_Pages		proc	near	; initialize paging directory and
;					; requisite tables.
;-----------------------------------------------------------------------------
; Input:   AX		  = Input status
;			    [B0,B1]=00 == Unity mapping
;				   =01 == Random mapping
;	   PSP_ADDR	  = segment address of PSP
;	   EXT_MEM_BLOCKS = # of 64K-byte blocks of extended memory
; Output:  None
; Register(s) modified:  AX, BX, CX, DX, EDI, DS
;-----------------------------------------------------------------------------

;-----------------------------------------------------------------------------
; Initialize page directories
;-----------------------------------------------------------------------------
	mov	edi,PDBR
	lea	eax,[edi][03h]
	mov	cx,ds:ext_mem_blocks	; get size of Extended memory in system
	shl	cx,6
	add	cx,400h 		; compensate for 0-1M ram addresses

;-----------------------------------------------------------------------------
; If there are any more than 1 page directory (more than 4M in the system),
; Then go through this loop initializing all subsequent directory entries.
;-----------------------------------------------------------------------------
@@:	add	eax,1000h		; point to next page table
	mov	dword ptr gs:[edi],eax	; fill in this entry of the page directory
	add	edi,4			; point to next entry
	sub	cx,1000h		; are we done yet?
	ja	@B			; nope

;-----------------------------------------------------------------------------
; Clear all unused page directory entries, and make them not present.
;-----------------------------------------------------------------------------
	xor	eax,eax 		; clear it
	xor	cx,cx
	sub	cx,ds:ext_mem_blocks	; get size of Extended memory in system
	sub	cx,10h			; align to next 4M boundry
	shr	cx,6
@@:	mov	dword ptr gs:[edi],0	; clear data
	add	edi,4
	loop	@B			; continue

;-----------------------------------------------------------------------------
; Prepare to initialize page tables for unity mapping.
;-----------------------------------------------------------------------------
	mov	eax,3			; initialize page table pointer w/ access
	mov	cx,ds:ext_mem_blocks	; get size of Extended memory in system
	shl	cx,6
	add	cx,400h 		; compensate for 0-1M ram addresses
	shr	cx,2			; make CX=4K pages in system
	mov	edi,PDBR		; get page directory base register
	add	edi,1000h		; point past page directory

@@:	mov	dword ptr gs:[edi],eax	; initialize page table entry
	add	edi,4			; point to next entry
	add	eax,1000h		; adjust pointer to next 4K block
	loop	@B			; continue until finished

@Split1:
	ret
Init4M_Pages	endp


;-----------------------------------------------------------------------------
  Init2M_Pages		proc	near	; initialize paging directory and
;					; requisite tables.
;-----------------------------------------------------------------------------
; Input:   EXT_MEM_BLOCKS = # of 64K-byte blocks of extended memory
; Output:  None
; Register(s) modified:  AX, BX, CX, DX, EDI, DS
;-----------------------------------------------------------------------------
	mov	edi,PDBR		; get base pointer to PDBR data

;-----------------------------------------------------------------------------
; Initialize page directory pointers
;-----------------------------------------------------------------------------
	lea	eax,[edi][1001h]	; make into page directory pointer
	mov	dword ptr gs:[edi][00h],eax
	mov	dword ptr gs:[edi][04h],0
	mov	dword ptr gs:[edi][08h],eax
	mov	dword ptr gs:[edi][0Ch],0
	mov	dword ptr gs:[edi][10h],eax
	mov	dword ptr gs:[edi][14h],0
	mov	dword ptr gs:[edi][18h],eax
	mov	dword ptr gs:[edi][1Ch],0

;-----------------------------------------------------------------------------
; Initialize page directories
;-----------------------------------------------------------------------------
	mov	edi,PDBR
	lea	edi,[edi][1000h]
	lea	eax,[edi][7h]
	movzx	ecx,ds:ext_mem_blocks	; get size of Extended memory in system
	add	ecx,400h		; compensate for 0-1M ram addresses

;-----------------------------------------------------------------------------
; If there are any more than 1 page directory (more than 4M in the system),
; Then go through this loop initializing all subsequent directory entries.
;-----------------------------------------------------------------------------
@@:	add	eax,1000h		; point to next page table
	mov	dword ptr gs:[edi],eax	; fill in this entry of the page directory
	mov	dword ptr gs:[edi][4],0 ; fill top dword
	add	edi,8			; point to next entry
	sub	ecx,800h		; are we done yet?
	ja	@B			; nope

;-----------------------------------------------------------------------------
; Clear all unused page directory entries, and make them not present.
;-----------------------------------------------------------------------------
	xor	eax,eax 		; clear it
	movzx	ecx,ds:ext_mem_blocks	; get size of Extended memory in system
	add	ecx,400h		; compensate for 0-1M ram addresses
	shr	ecx,0bh 		; divide by 2048
	sub	cx,200h 		; number of entries in page directory
	neg	cx

@@:	mov	dword ptr gs:[edi],0	; clear data
	mov	dword ptr gs:[edi][4],0
	add	edi,8
	loop	@B			; continue

;-----------------------------------------------------------------------------
; Prepare to initialize page tables for unity mapping.
;-----------------------------------------------------------------------------
	mov	eax,7			; initialize page table pointer w/ access
	movzx	ecx,ds:ext_mem_blocks	; get size of Extended memory in system
	add	ecx,400h		; compensate for 0-1M ram addresses
	shr	cx,2			; make CX=4K pages in system
	mov	edi,PDBR		; point to first page table
	lea	edi,[edi][2000h]

@@:	mov	dword ptr gs:[edi],eax	; initialize page table entry
	mov	dword ptr gs:[edi][4],0 ; fill top dword
	add	edi,8			; point to next entry
	add	eax,1000h		; adjust pointer to next 4K block
	loop	@B			; continue until finished
	ret
Init2M_Pages	endp


;-----------------------------------------------------------------------------
  GetLinear4M	proc	near	; Convert selector:offset to linear address
;-----------------------------------------------------------------------------
; Input:   EDX:EAX = Selector:Offset
; Output:      EBX = Linear address
;	       EDX = Linear address of page directory entry
;	       EAX = Linear address of page table entry
;-----------------------------------------------------------------------------
	push	ecx
	mov	bh,GDT_PTR.Base_A31_A24[edx]
	mov	bl,GDT_PTR.Base_A23_A16[edx]
	shl	ebx,10h
	mov	bx,GDT_PTR.Base_A15_A00[edx]
	add	ebx,eax 		; now have linear address
	mov	edx,ebx 		; make a copy of linear address

;					    AAAR   PP
;			33222222222211111111VVVSP  CW
;			10987654321098765432LLLVSDADTUWP
	and	edx,not 00000000001111111111111111111111y
	shr	edx,20d 		; make into index into page directory
	add	edx,PDBR		; add page directory base


	mov	eax,dword ptr gs:[edx]	; get base address of page table
;					    AAAR   PP
;			33222222222211111111VVVSP  CW
;			10987654321098765432LLLVSDADTUWP
	and	eax,not 00000000000000000000111111111111y

	mov	ecx,ebx 		; make a copy of linear address
;					    AAAR   PP
;			33222222222211111111VVVSP  CW
;			10987654321098765432LLLVSDADTUWP
	and	ecx,not 11111111110000000000111111111111y
	shr	ecx,10d
	add	eax,ecx
	pop	ecx
	ret
GetLinear4M	endp


;-----------------------------------------------------------------------------
  GetPDBR	proc	near	; Routine to return the best possible address
;				; for the page tables.
;-----------------------------------------------------------------------------
; Input:   None
; Output:  EDX =
;-----------------------------------------------------------------------------
	psp_addr	equ	[bp-4]
	push	es
	push	bp
	mov	bp,sp
	sub	sp,4
	mov	ah,62h			; set function to read PSP
	int	21h			; get PSP
	jc	@NoPaging		; oops
	mov	psp_addr,bx		; save current PSP address
	mov	ah,4ah			; DOS function to shrink memory
	mov	bx,seg _ZSEG
	add	bx,1000h/10h		; assume 4K stack
	sub	bx,psp_addr		; convert to # of paragraphs to resize
	mov	dx,psp_addr		; get PSP address
	mov	es,dx			; ES = psp_addr.psp_segmentESS
	int	21h			; go shrink memory
	jc	@NoPaging		; oops
	mov	dx,seg _ZSEG		; get stack segment
	add	dx,1000h/10h		; point past stack space
	and	edx,0000FF00h		; keep only value in AH
	add	edx,00000100h		; point to next 4k-page
	shl	edx,4			; make into physical address
	mov	sp,bp
	pop	bp
	pop	es
	ret				; go split

@NoPaging:
	mov	dx,offset PageTblErr
	mov	sp,bp
	pop	bp
	pop	es
	ret				; split
GetPDBR 	endp

_TEXT	ends

	_ZSEG	segment para public 'DATA'
	_ZSEG	ends

	end
