#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>

#define CLIPRANGE	0
#define BLOWUP		2
	
inline short abs( short value );
void clipFilter( void );
void dataOut( FILE *fp, int offset, int magnitude );
int calculateTolerance( int stop );
void encodeSam( char *audiosample, char *audioencoded );
void dataInt64( FILE *fp, __int64 value );
int check_registration( void );

int rllbits = 4;
int atolerance;

short buffer[ 50 ];
__int64 capabilities = 0;
__int64 decoded_length;
__int64 encoded_length;
__int64 weeks_time;
__int64 registration = 0;

int main( int argc, char **argv )
{
	float totalsecs;
	float bandwidth;
	int requirement = 2300;
	FILE *fp;

	if( argc == 4 )
	{
		requirement = atoi( argv[ 3 ] );
		argc--;
		if(( requirement < 1200 ) && ( requirement > 20 ))
		{
			printf( "idtencode - sorry, can't compress that well\n" );
			exit( -1 );
		}
	}

	if( argc != 3 )
	{
		printf( "Usage:\n" );
		printf( "idtencode infile outfile\n" );
		exit( -1 );
	}
	
	// Read in registration value
	fp = fopen( "reg.txt", "r" );
	if( fp )
	{
		__int64 number;

		fscanf( fp, "%I64x", &number );
		fclose( fp );
		registration = number;
	}

	// Print banner
	printf( "idtEncode V1.0 Beta 1\n" );
	printf( "by L. Richard Moore Jr.\n" );
	printf( "Copyright (c) 1996, 1997\n" );
	printf( "All Rights Reserved.\n" );

	// If valid registration...
	if( check_registration())
	{
		weeks_time = 0;
		printf( "(Registered)\n" );
	}
	else
		weeks_time = time( NULL ) / 60 + ( 60 * 24 * 7 );

	printf( "\n" );

	atolerance = 0;
	if( requirement <= 20 )
	{
		atolerance = requirement;
		encodeSam( argv[ 1 ], argv[ 2 ] );
		totalsecs = (float) decoded_length / 8000;
		bandwidth = encoded_length / totalsecs;
		printf( "Try %d yielded bandwidth requirement of %d\n", atolerance, (int) bandwidth );
	}
	else
	{
		do
		{
			atolerance++;
			encodeSam( argv[ 1 ], argv[ 2 ] );
			totalsecs = (float) decoded_length / 8000;
			bandwidth = encoded_length / totalsecs;

			printf( "Try %d yielded bandwidth requirement of %d\n", atolerance, (int) bandwidth );
		}
		while( bandwidth > requirement );
	}

	return( 0 );
}

int check_registration( void )
{
	int index;
	unsigned char cs = 0;

	for( index = 56; index >= 0; index -= 8 )
		cs ^= ( registration >> index ) & 0xff;
	return( cs == 'M' );
}

inline short abs( short value )
{
	if( value < 0 )
		return( -value );
	return( value );
}

short ssqrt( short value )
{
	short result;

	if( value > 0 )
	{
		result = (short) sqrt((double) value );
		if( result > 7 )
			result = 7;
	}
	else if( value < 0 )
	{
		result = (short) -sqrt((double) -value );
		if( result < -8 )
			result = -8;
	}
	else
		result = 0;

	return( result );
}

void encodeSam( char *audiosample, char *audioencoded )
{
	FILE *ifp;
	FILE *ofp;
	int index;
	int value;

	if( ! ( ofp = fopen( audioencoded, "wb" )))
	{
		printf( "Could not open '%s' for writing\n", audioencoded );
		exit( -2 );
	}

	if( ! ( ifp = fopen( audiosample, "rb" )))
	{
		printf( "Could not open '%s' for reading\n", audiosample );
		exit( -3 );
	}

	// Reset global variables
	decoded_length = 0;
	encoded_length = 0;

	// Write header space
	fwrite( buffer, 40, 1, ofp );

	// Write initial datapoint
	buffer[ 0 ] = fgetc( ifp );
	dataOut( ofp, 0, ssqrt( buffer[ 0 ] ));
	index = 1;

	value = fgetc( ifp );
	decoded_length++;
	while( value != EOF )
	{
		buffer[ index ] = (short) (char) value;
		if( calculateTolerance( index ) > atolerance )
		{
			dataOut( ofp, index - 2, ssqrt( buffer[ index - 1 ] ));
			buffer[ 0 ] = buffer[ index - 1 ];
			buffer[ 1 ] = buffer[ index ];
			index = 1;
		}
		index++;
		value = fgetc( ifp );
		decoded_length++;
	}

	dataOut( ofp, index - 2, ssqrt( buffer[ index - 1 ] ));

	// Rewrite correct header information not that we have it
	fseek( ofp, 0, SEEK_SET );
	dataInt64( ofp, capabilities );
	dataInt64( ofp, encoded_length );
	dataInt64( ofp, decoded_length );
	dataInt64( ofp, weeks_time );
	dataInt64( ofp, registration );

	fclose( ofp );
	fclose( ifp );
}

void dataInt64( FILE *fp, __int64 value )
{
	int index;

	for( index = 56; index >= 0; index -= 8 )
		fputc((int) ( value >> index ) & 0xff, fp );
}

void dataOut( FILE *fp, int offset, int magnitude )
{
	unsigned char byte;

	encoded_length++;
	byte = (( magnitude << 4 ) + offset ) & 0xff;
	fwrite( &byte, 1, 1, fp );
}

int calculateTolerance( int stop )
{
	int index;
	int maxtolerance = 0;
	int tolerance;
	int rise;
	int run = stop;
	int y;

	if( run > ( 1 << rllbits ))
		return( atolerance + 1 );
	if( run < 2 )
		return( 0 );

	rise = buffer[ stop ] - buffer[ 0 ];
	for( index = 1; index < run; ++index )
	{
		y = ( index * rise ) / run + buffer[ 0 ];
		tolerance = abs( y - buffer[ index ] );
		if( tolerance > maxtolerance )
			maxtolerance = tolerance;
	}
	return( maxtolerance );
}
