/* recit.c -- Time cost of recursion vs. iteration
	Usage: recit <n>
	Takes one integer parameter, and runs time tests.
	Start with 500 and work up: 500, 1000, 2000, 4000, ...
	Change MAXN if you go above 10000
 */

#include <stdlib.h>
#include <stdio.h>
#include <time.h>

#define MAXN 10000
int n;

/* STRINGS */

char s1[MAXN], s2[MAXN];

int istrlen(char *s)
{	int n = 0;
	for ( ; *s; s++)
		n++;
	return n;
}

int rstrlen(char *s)
{	if (*s) return 1+rstrlen(s+1);
	else return 0;
}

int rcstrlen(char *s)
{	return *s ? 1+rcstrlen(s+1) : 0; }

int istrcmp(char *s, char *t)
{	for ( ; *s == *t; s++, t++)
		if (*s == 0)
			return 0;
	return *s - *t;
}

int rstrcmp(char *s, char *t)
{	if (*s == *t) {
		if (*s)
			return rstrcmp(s+1, t+1);
		else
			return 0;
	} else
		return (*s - *t);
}

int rcstrcmp(char *s, char *t)
{	return (*s == *t) ?
		  (*s ? rcstrcmp(s+1, t+1) : 0)
		: *s - *t;
}

int ihdist(char *s, char *t)
{	int d = 0;
	for ( ; ; s++, t++) {
		if (!*s) return d+istrlen(t);
		if (!*t) return d+istrlen(s);
		if (*s != *t) d++;
	}
}

int rhdist(char *s, char *t)
{	if (!*s) return rstrlen(t);
	if (!*t) return rstrlen(s);
	return (*s == *t ? 0 : 1) + rhdist(s+1, t+1);
}


/* ARRAY SORTING AND SEARCHING */

int a[MAXN];

void inita()
{	int i;
	for (i = 0; i < n; i++)
		a[i] = n-i;
}

/* sift down element in a[n] */

void isiftdown(int n)
{	int i, t;
	for (i = n; i > 0 && a[i-1] > a[i]; i--) {
		t = a[i]; a[i] = a[i-1]; a[i-1] = t;
	}
}

void rsiftdown(int n)
{	int t;
	if (n > 0 && a[n-1] > a[n]) {
		t = a[n]; a[n] = a[n-1]; a[n-1] = t;
		rsiftdown(n-1);
	}
}

int isearch(int n, int t)
{	while (--n >= 0)
		if (a[n] == t)
			return n;
	return -1;
}

int rsearch(int n, int t)
{	if (--n < 0)
		return -1;
	if (a[n] == t)
		return n;
	return rsearch(n, t);
}

int rcsearch(int n, int t)
{	return (--n < 0) ? -1 :
	((a[n] == t) ? n : rcsearch(n, t));
}

/* BINARY SEARCH TREE ALGS */

typedef struct tnode *Tptr;
typedef struct tnode {
    int val;
    Tptr lo, hi;
} Tnode;
Tptr root;

void iinsert(int t)
{	Tptr p, q;
	Tptr next = (Tptr) malloc(sizeof(Tnode));
	if (!root)
		root = next;
	else {
		for (q = root; q; ) {
			p = q;
			q = (t < p->val) ? q->lo : q->hi;
		}
		if (t < p->val)
			p->lo = next;
		else
			p->hi = next;
	}
	next->lo = next->hi = 0;
	next->val = t;
}

void iinsertpp(int t) /* Pointer to pointer version */
{	Tptr *p = &root;
	while (*p) {
		if (t < (*p)->val)
			p = &((*p)->lo);
		else
			p = &((*p)->hi);
	}
	*p = (Tptr) malloc(sizeof(Tnode));
	(*p)->lo = (*p)->hi = 0;
	(*p)->val = t;
}

Tptr rinsert(Tptr p, int t)
{	if (p) {
		if (t < p->val)
			p->lo = rinsert(p->lo, t);
		else
			p->hi = rinsert(p->hi, t);
	} else {
		p = (Tptr) malloc(sizeof(Tnode));
		p->lo = p->hi = 0;
		p->val = t;
	}
	return p;
}

void cleanup(Tptr p)
{	if (!p) return;
	cleanup(p->lo);
	cleanup(p->hi);
	free(p);
}

int ibstsearch(int t)
{	Tptr p;
	for (p = root; p; ) {
		if (t == p->val)
			return 1;
		p = (t < p->val) ? p->lo : p->hi;
	}
	return -1;
}

int rbstsearch(Tptr p, int t)
{	if (!p) return -1;
	if (t == p->val) return 1;
	if (t < p->val) return rbstsearch(p->lo, t);
	return rbstsearch(p->hi, t);
}

int rcbstsearch(Tptr p, int t)
{	return !p ? -1 :
	( (t == p->val) ? 1 :
	( (t < p->val) ? rcbstsearch(p->lo, t): rcbstsearch(p->hi, t) ));
}

int count;

void rcount(Tptr p)
{	if (!p) return;
	rcount(p->lo);
	count++;
	rcount(p->hi);	
}

void rcount2(Tptr p)
{	if (p->lo) rcount2(p->lo);
	count++;
	if (p->hi) rcount2(p->hi);	
}

void rcount3(Tptr p)
{	while (p) {
		if (p->lo) rcount3(p->lo);
		count++;
		p = p->hi;
	}
}

void icount(Tptr p)
{	Tptr s[MAXN];
	int sp = 0;
	for (;;) {
		while (p) {
			s[sp++] = p;
			p = p->lo;
		}
		if (sp == 0) break;
		p = s[--sp];
		count++;
		p = p->hi;
	}
}


/* TIMING SUPPORT */

#define RPT 5
#define TITLE(s)	printf("%s\n", s);		
#define EXPER(label, preop, op)					\
	printf("%s", label);						\
	tc = 0;										\
	for (rptctr=0; rptctr<RPT; rptctr++) {		\
		int nc;									\
		preop;									\
		starttime = clock();					\
		for (i = 0; i < n; i++) { op; }			\
		tc += (nc = clock()-starttime);			\
		printf("\t%d", nc);						\
	}											\
	printf("\t%3.0f\n", (1e9*tc) /				\
		(1.0*RPT*n*n*CLOCKS_PER_SEC));

/* MAIN */

int main(int argc, char *argv[])
{   int i, j, rptctr, starttime, tc, globalstarttime;
	globalstarttime = clock();
	n = atoi(argv[1]);
	setbuf(stdout, 0);
	printf("n=%d\n", n);
	TITLE("Warmup (smooth first times)")
	for (i = 0; i < n-1; i++)
		s1[i] = s2[i] = '1';
	s1[n-1] = s2[n-1] = 0;
	EXPER("istrlen", i=0, j = istrlen(s1));
	EXPER("istrlen", i=0, j = istrlen(s1));
	TITLE("Strings");
	EXPER("istrlen", i=0, j = istrlen(s1));
	EXPER("rstrlen", i=0, j = rstrlen(s1));
	EXPER("rcstrlen", i=0, j = rcstrlen(s1));
	EXPER("istrcmp", i=0, j = istrcmp(s1, s2));
	EXPER("rstrcmp", i=0, j = rstrcmp(s1, s2));
	EXPER("rcstrcmp", i=0, j = rcstrcmp(s1, s2));
	EXPER("ihdist", i=0, j = ihdist(s1, s2));
	EXPER("rhdist", i=0, j = rhdist(s1, s2));
	TITLE("Arrays");
	EXPER("isiftdown", inita(), isiftdown(i-1));
	EXPER("rsiftdown", inita(), rsiftdown(i-1));
	EXPER("isearch", i=0, j = isearch(n, i));
	EXPER("rsearch", i=0, j = rsearch(n, i));
	EXPER("rcsearch", i=0, j = rcsearch(n, i));
	TITLE("Binary Search Trees");
	root = 0;
	EXPER("iinsert", cleanup(root); root=0, iinsert(i));
	EXPER("iinsertpp", cleanup(root); root=0, iinsertpp(i));
	EXPER("rinsert", cleanup(root); root=0, root=rinsert(root, i));
	EXPER("ibstsearch", i=0, j = ibstsearch(i));
	EXPER("rbstsearch", i=0, j = rbstsearch(root, i));
	EXPER("rcbstsearch", i=0, j = rcbstsearch(root, i));
	cleanup(root);
	TITLE("Random BSTs");
	root = 0;
	for (i = 0; i < n; i++)
		root = rinsert(root, rand());
	EXPER("rcount", count=0, rcount(root));
	EXPER("rcount2", count=0, rcount2(root));
	EXPER("rcount3", count=0, rcount3(root));
	EXPER("icount", count=0, icount(root));
	i = clock() - globalstarttime;
	printf("Total clicks\t%d\nTotal secs\t%4.3f\n",
		i, (double) i / CLOCKS_PER_SEC);
	return 0;
}

