#ifndef ___DS_LIB_H__
#define ___DS_LIB_H__

/*
Copyright (c) 1998 by UWI Unisoft Wares Inc.
   UWI.Com -- The Internet Forms Company
   400 - 1095 McKenzie Ave.
   Victoria, British Columbia Canada V8P 2L5
   1-888-517-2675
   http://www.uwi.com

Author: John Boyer

Neither John Boyer, UWI Unisoft Wares Inc., nor Dr. Dobb's Journal will be
   liable under any circumstances for any direct or indirect damages arising
   from any use, direct or indirect, of this software. This software is
   provided with no warranty, implicit or explicit.

UWI Unisoft Wares Inc. grants you license to use this software in your programs
under the following conditions:
1) This copyright and license message must remain in this source code.
2) The following copyright message must appear in the program credits and
        documentation acknowledgements of software containing this library

   The Digital Signature Library for Microsoft(R) CryptoAPI
   Written By John Boyer Copyright (c) 1998 by UWI Unisoft Wares Inc.
*/

#include <windows.h>
#include "wincrypt.h"
#include "winerror.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Declaration of the Cert function array */

typedef HCERTSTORE (WINAPI *CertOpenSystemStoreProcType)(HCRYPTPROV hProv, LPCSTR szSubsystemProtocol);
typedef BOOL (WINAPI *CryptReleaseContextProcType)(HCRYPTPROV hProv, DWORD dwFlags);
typedef BOOL (WINAPI *CertCloseStoreProcType)(HCERTSTORE hCertStore, DWORD dwFlags);
typedef BOOL (WINAPI *CertFreeCertificateContextProcType)(PCCERT_CONTEXT pCertContext);
typedef BOOL (WINAPI *CryptSignMessageProcType)(PCRYPT_SIGN_MESSAGE_PARA pSignPara, BOOL fDetachedSignature, DWORD cToBeSigned, const BYTE *rgpbToBeSigned[], DWORD rgcbToBeSigned[], BYTE *pbSignedBlob, DWORD *pcbSignedBlob);
typedef BOOL (WINAPI *CryptVerifyDetachedMessageSignatureProcType)(PCRYPT_VERIFY_MESSAGE_PARA pVerifyPara, DWORD dwSignerIndex, const BYTE *pbDetachedSignBlob, DWORD cbDetachedSignBlob, DWORD cToBeSigned, const BYTE *rgpbToBeSigned[], DWORD rgcbToBeSigned[], OPTIONAL PCCERT_CONTEXT *ppSignerCert);
typedef PCCERT_CONTEXT (WINAPI *CertEnumCertificatesInStoreProcType)(HCERTSTORE hCertStore, PCCERT_CONTEXT pPrevCertContext);
typedef DWORD (WINAPI *CertNameToStrProcType)(DWORD dwCertEncodingType, PCERT_NAME_BLOB pName, DWORD dwStrType, LPSTR psz, DWORD csz);
typedef BOOL (WINAPI *CryptDecodeObjectProcType)(DWORD dwCertEncodingType, LPCSTR lpszStructType, const BYTE *pbEncoded, DWORD cbEncoded, DWORD dwFlags, void *pvStructInfo, DWORD *pcbStructInfo);
typedef PCERT_RDN_ATTR (WINAPI *CertFindRDNAttrProcType)(LPCSTR pszObjId, PCERT_NAME_INFO pName);
typedef DWORD (WINAPI *CertRDNValueToStrProcType)(DWORD dwValueType, PCERT_RDN_VALUE_BLOB pValue, LPSTR psz, DWORD csz);
typedef PCCERT_CONTEXT (WINAPI *CertGetIssuerCertificateFromStoreProcType)(HCERTSTORE hCertStore, PCCERT_CONTEXT pSubjectContext, PCCERT_CONTEXT pPrevIssuerContext, DWORD *pdwFlags);
typedef BOOL (WINAPI *CryptAcquireContextProcType)(HCRYPTPROV *phProv, LPCSTR pszContainer, LPCSTR pszProvider, DWORD dwProvType, DWORD dwFlags);
typedef PCCERT_CONTEXT (WINAPI *CertGetSubjectCertificateFromStoreProcType)(HCERTSTORE hCertStore, DWORD dwCertEncodingType, PCERT_INFO pCertId);
typedef LONG (WINAPI *CertVerifyTimeValidityProcType)(LPFILETIME pTimeToVerify, PCERT_INFO pCertInfo);
typedef BOOL (WINAPI *CertCompareIntegerBlobProcType)(PCRYPT_INTEGER_BLOB pInt1, PCRYPT_INTEGER_BLOB pInt2);
typedef BOOL (WINAPI *CertVerifySubjectCertificateContextProcType)(PCCERT_CONTEXT pSubject, PCCERT_CONTEXT pIssuer, DWORD *pdwFlags);
typedef BOOL (WINAPI *CertGetCertificateContextPropertyProcType)(PCCERT_CONTEXT pCertContext, DWORD dwPropId, void * pvData, DWORD * pcbData);
typedef DWORD(WINAPI *CertGetPublicKeyLengthProcType)(DWORD dwCertEncodingType, PCERT_PUBLIC_KEY_INFO pPublicKey);

typedef struct
{
	HINSTANCE	theCryptModule;
	HINSTANCE	theAdvModule;

	CertOpenSystemStoreProcType			CertOpenSystemStoreProc;
        CryptReleaseContextProcType			CryptReleaseContextProc;
        CertCloseStoreProcType				CertCloseStoreProc;
        CertFreeCertificateContextProcType		CertFreeCertificateContextProc;
        CryptSignMessageProcType			CryptSignMessageProc;
        CryptVerifyDetachedMessageSignatureProcType	CryptVerifyDetachedMessageSignatureProc;
        CertEnumCertificatesInStoreProcType		CertEnumCertificatesInStoreProc;
        CertNameToStrProcType				CertNameToStrProc;
        CryptDecodeObjectProcType			CryptDecodeObjectProc;
        CertFindRDNAttrProcType				CertFindRDNAttrProc;
        CertRDNValueToStrProcType			CertRDNValueToStrProc;
        CertGetIssuerCertificateFromStoreProcType	CertGetIssuerCertificateFromStoreProc;
        CryptAcquireContextProcType			CryptAcquireContextProc;
        CertGetSubjectCertificateFromStoreProcType	CertGetSubjectCertificateFromStoreProc;
        CertVerifyTimeValidityProcType			CertVerifyTimeValidityProc;
        CertCompareIntegerBlobProcType			CertCompareIntegerBlobProc;
        CertVerifySubjectCertificateContextProcType	CertVerifySubjectCertificateContextProc;
	CertGetCertificateContextPropertyProcType	CertGetCertificateContextPropertyProc;
        CertGetPublicKeyLengthProcType			CertGetPublicKeyLengthProc;
} CryptFuncEnv;

extern CryptFuncEnv *theCryptEnv;

/* Declarations of private functions and structures */

typedef struct
{
     HCRYPTPROV hCryptProv;
     charP signature, msg;
     long signatureLen, msgLen;
     charP signer;
     charP CertInfo;
     charP CertChain;
     short result;
} DSUserDataForVerify;

/**********************************************************************/
short _DSFindRDNAttr(LPCSTR pszAttrId, PCCERT_CONTEXT pCertContext, charP *pAttr);

/**********************************************************************/
short _DSGetSubjectFromCert(PCCERT_CONTEXT pCertContext, charP *pCertSubject,
			      short wholeSubject);

/**********************************************************************/
short _DSGetIssuerCert(PCCERT_CONTEXT SignerCert, HCRYPTPROV hCryptProv,
                       HCERTSTORE *pStore, PCCERT_CONTEXT *pIssuerCert);

/**********************************************************************/
short _DSCheckCertificate(PCCERT_CONTEXT Cert, HCRYPTPROV hCryptProv);

/**********************************************************************/
short _DSTestSignatureProperty(PCCERT_CONTEXT pCertContext);

/**********************************************************************/
short _DSFindCertificate(HCRYPTPROV hCryptProv, HCERTSTORE hCertStore,
                         charP certId, PCCERT_CONTEXT *certContextPtr);

/**********************************************************************/
short _DSGetCertChain(PCCERT_CONTEXT pSignerCert, DSUserDataForVerify *pVerifyArg);

/**********************************************************************/
short _DSCryptAcquireContext(HCRYPTPROV *phProv, LPSTR pszContainer,
			     LPSTR pszProvider, DWORD dwFlags);

/**********************************************************************/
PCCERT_CONTEXT WINAPI _DSGetVerificationCertificate(
	void *pvVerifyArg, DWORD dwCertEncodingType,
	PCERT_INFO pSignerId, HCERTSTORE hMsgCertStore);

/**********************************************************************/
short _DSTrustSigner(DSUserDataForVerify *pVerifyArg);

/**********************************************************************/
short __DSTrustSigner(PCCERT_CONTEXT signerCert,
			DSUserDataForVerify *pVerifyArg, HCERTSTORE certStore);

/**********************************************************************/

#ifdef __cplusplus
}
#endif

#endif