#ifndef _CHARP_C
#define _CHARP_C

/*
Copyright (c) 1998 by UWI Unisoft Wares Inc.
   UWI.Com -- The Internet Forms Company 
   400 - 1095 McKenzie Ave.
   Victoria, British Columbia Canada V8P 2L5
   1-888-517-2675
   http://www.uwi.com

Author: John Boyer

Neither John Boyer, UWI Unisoft Wares Inc., nor Dr. Dobb's Journal will be
   liable under any circumstances for any direct or indirect damages arising
   from any use, direct or indirect, of this software. This software is
   provided with no warranty, implicit or explicit.

UWI Unisoft Wares Inc. grants you license to use this software in your programs
under the following conditions:
1) This copyright and license message must remain in this source code.
2) The following copyright message must appear in the program credits and
        documentation acknowledgements of software containing this library

   The Digital Signature Library for Microsoft(R) CryptoAPI
   Written By John Boyer Copyright (c) 1998 by UWI Unisoft Wares Inc.
*/
/* This is a pared down version of a library that supports all memory allocation
	and string work in UWI's projects;  It deals with cross-platform
        issues like huge pointers for 16 bit windows and the lack of certain
        functions under some flavors of UNIX. */

#include "charp.h"

#include <stdlib.h>

/**************************************************************************/
/* This function mallocs memory in a cross-platform manner.

	@param Size NI - the number of bytes of memory requested

        @return U - the memory block that was requested or NULL on
        	failure

        @access public
*/
/**************************************************************************/

charP cp_malloc(long Size)
{
charP           p;

#if defined(WINDOWS) && !defined(__FLAT__)
	p = (charP) farmalloc(Size);
#else
	p = (charP) malloc(Size);
#endif

	return p;
}

/**************************************************************************/
/* This function reallocates memory in a cross-platform manner.

	@param oldPtr LI - the old pointer. This pointer may be destroyed
        	as part of the inner workings of this function

        @param Size NI - the new size of the memory block requested

	@param CurSize NI - indicates the current size of the memory block.
        	This is not usually needed, but one of Microsoft C's
                current huge pointer strategies requires it. Unless you
                have rewritten the functions in this library to use
                something other than the default SLICC code (e.g. to
                use Microsoft C Win16 huge pointers), then CurSize
                will not be needed and can be set to zero.

        @return U - the new reallocated memory block or NULL on failure

        @access public
*/
/**************************************************************************/
charP cp_realloc(charP oldPtr, long Size, long CurSize)
{
charP           newPtr;

	if (oldPtr == NULL)
		return cp_malloc(Size);

        if (Size == 0)
        {
        	cp_free(oldPtr);
                return(NULL);
        }

#if defined(WINDOWS) && !defined(__FLAT__)
#ifdef MSC
	newPtr = (charP) _hrealloc(oldPtr, Size, CurSize);
#else
	newPtr = (charP) farrealloc(oldPtr, Size);
#endif
#else
	newPtr = (charP) realloc(oldPtr, Size);
#endif

	return newPtr;
}

/**************************************************************************/
/* This function frees a memory block allocated with other cp_ functions.

	@param thePtr LI - the memory block to free

        @return N nothing

        @access public
*/
/**************************************************************************/
void cp_free(charP thePtr)
{
	if (thePtr == NULL)
		return;

#if defined(WINDOWS) && !defined(__FLAT__)
	farfree(thePtr);
#else
	free(thePtr);
#endif
}

/**************************************************************************/
/* This function calculates the length of a string.

	@param s UI - the string to calculate

        @return N the length of the string

        @access public
*/
/**************************************************************************/

long cp_strlen(charP s)
{
long    count = 0;

	if (s == NULL)
		return 0;

	while (*s != '\0')
	{
		s++;
		count++;
	}

	return count;
}

/**************************************************************************/
/* This function copies one string to the other.

	@param dst UI - the destination string

        @param src UI - the source string

        @return U the dst string

        @access public
*/
/**************************************************************************/

charP cp_strcpy(charP dst, charP src)
{
charP   result = dst;

	if (dst == NULL)
		return NULL;

	if (src != NULL)
		while (*src != '\0')
			*dst++ = *src++;

	*dst = '\0';
	return result;
}

/**************************************************************************/
/* This function concatenates one string onto another.

	@param dst UI - the destination string

        @param src UI - the source string

        @return U - the destination string

        @access public
*/
/**************************************************************************/

charP cp_strcat(charP dst, charP src)
{
charP           result = dst;

	if (dst == NULL)
		return NULL;
	if (src == NULL)
		return dst;

	while (*dst != '\0')
		dst++;

	cp_strcpy(dst, src);
	return result;
}

/**************************************************************************/
/* This function compares two strings.

	@param s1 UI - the first string

        @param s2 UI - the second string

        @return N 0 if the strings are identical. <0 if s1 is less
        	than s2 and >0 if s1 is greater than s2

        @access public
*/
/**************************************************************************/

int cp_strcmp(charP s1, charP s2)
{
int     Result;

	if (s1 == NULL)
		return s2 == NULL || *s2 == '\0' ? 0 : -1;
	else if (s2 == NULL)
		return *s1 == '\0' ? 0 : 1;

	while (*s1 != '\0')
	{
		if ((Result = (int) *s1 - (int) *s2) != 0)
			return Result;
		s1++;
		s2++;
	}

	return (int) *s1 - (int) *s2;
}

/**************************************************************************/
/* This function duplicates an existing string.

	@param str UI - the string to duplicate

        @return U - the duplicated string

        @access public
*/
/**************************************************************************/

charP cp_strdup(charP str)
{
charP   result = cp_malloc(cp_strlen(str) + 1);

	if (result != NULL)
		cp_strcpy(result, str);

	return result;
}

/**************************************************************************/
/* This function finds the first occurrence of a character within a
	string.

        @param str UI - the string to search

        @param ch NI - the character to look for

        @return U - a pointer to the first character within the string
        	that matches the character or NULL if there is no match

        @access public
*/
/**************************************************************************/

charP cp_strchr(charP str, char ch)
{
	if (str == NULL)
		return NULL;

	while (*str != '\0')
	{
		if (*str == ch)
			return str;
		str++;
	}

	return *str == ch ? str : NULL;
}

/**************************************************************************/
/* This function copies one memory block to another.

	@param dst UI - the destination memory block

        @param src UI - the source memory block

        @param n NI - the number of bytes to copy

        @return U the destination memory block

        @access public
*/
/**************************************************************************/

charP cp_memcpy(charP dst, charP src, long n)
{
charP result = dst;

      if (dst == NULL) return NULL;

      if (src != NULL)
          while (n-- > 0)
	      *dst++ = *src++;

      return result;
}

/**************************************************************************/
/* This function compares two strings.

	@param s1 UI - the first string

        @param s2 UI - the second string

        @param n N - the maximum number of characters to compare

        @return N 0 if the strings are identical. <0 if s1 is less
        	than s2 and >0 if s1 is greater than s2

        @access public
*/
/**************************************************************************/

int cp_strncmp(charP s1, charP s2, long n)
{
long I;

     if (s1 == NULL)
	  return s2==NULL || *s2=='\0' ? 0 : -1;
     else if (s2 == NULL)
	  return *s1=='\0' ? 0 : 1;

     for (I = 0; I < n; I++)
     {
	  if (*s1 != *s2)
	      return *s1 < *s2 ? -1 : 1;
	  else if (*s1 == '\0')
	      return 0;
	  s1++;
	  s2++;
     }

     return 0;
}

/**************************************************************************/
/* This function finds the last occurrence of a character within a
	string.

        @param str UI - the string to search

        @param ch NI - the character to look for

        @return U - a pointer to the last occurrence of the character
        	or NULL if there is no match

        @access public
*/
/**************************************************************************/

charP cp_strrchr(charP str, char ch)
{
charP P;

      if (str == NULL) return NULL;

      P = str + cp_strlen(str);

      while (P != str)
      {
	  if (*P == ch) return P;
	  P--;
      }

      return *P == ch ? P : NULL;
}

/**************************************************************************/
/* This function finds the first occurrence of one string within another.

	@param s1 UI - the string to search

        @param s2 UI - the string to look for

        @return U - a pointer to the beginning of the search string
        	within s1 or NULL if there is no match

        @access public
*/
/**************************************************************************/

charP cp_strstr(charP s1, charP s2)
{
long s2len;

	if (s1 == NULL || s2 == NULL)
		return (NULL);

	if ((s2len = cp_strlen(s2)) == 0)
		return (s1);

	while (s1[0] != '\0')
	{
		if (cp_strncmp(s1, s2, s2len) == 0)
			return (s1);
		s1++;
	}
	return (NULL);
}

/**************************************************************************/
/* This function frees a list of pointers.

	@param theListPtr LB - a pointer to a list of pointers.

        @param theListCount NI - the number of pointers within the list

        @return N nothing

        @access public
*/
/**************************************************************************/

void cp_freelist(charP **theListPtr, long theListCount)
{
long		counter;

/* If the list is empty, then there's nothing to do */

	if (theListPtr==NULL || *theListPtr==NULL || theListCount==0)
        	return;

	for(counter=0;counter<theListCount;counter++)
        	cp_free((charP)(*theListPtr)[counter]);

        cp_free((charP)(*theListPtr));

        (*theListPtr) = NULL;
}

#endif

