/* *** ds_lib.c ***

Copyright (c) 1998 by UWI Unisoft Wares Inc.
   UWI.Com -- The Internet Forms Company 
   400 - 1095 McKenzie Ave.
   Victoria, British Columbia Canada V8P 2L5
   1-888-517-2675
   http://www.uwi.com

Author: John Boyer

Neither John Boyer, UWI Unisoft Wares Inc., nor Dr. Dobb's Journal will be
   liable under any circumstances for any direct or indirect damages arising
   from any use, direct or indirect, of this software. This software is
   provided with no warranty, implicit or explicit.

UWI Unisoft Wares Inc. grants you license to use this software in your programs
under the following conditions:
1) This copyright and license message must remain in this source code.
2) The following copyright message must appear in the program credits and
        documentation acknowledgements of software containing this library

   The Digital Signature Library for Microsoft(R) CryptoAPI
   Written By John Boyer Copyright (c) 1998 by UWI Unisoft Wares Inc.
*/

#include "ds_lib.h"
#include "_ds_lib.h"
#include "dserror.h"

short		theCryptModuleIsPresent = NOTOK;
CryptFuncEnv	*theCryptEnv = NULL;

/**********************************************************************/
/* This function clears the CryptFuncEnv structure.

	@access public
*/
/**********************************************************************/

void  DSFreeCryptEnv(void)
{
      if (theCryptEnv != NULL)
      {
          theCryptModuleIsPresent = NOTOK;
          FreeLibrary(theCryptEnv->theCryptModule);
          FreeLibrary(theCryptEnv->theAdvModule);
	  cp_free((charP)theCryptEnv);
	  theCryptEnv = NULL;
      }
}

/**********************************************************************/
/* This function loads the functions into the CryptFuncEnv structure.
	The other functions will automatically call this function, so
        you only need to call it if you want to know whether the cryptoAPI
        is available.

	@return N OK on success or an error code on failure

        @access public
*/
/**********************************************************************/

short DSPrepCryptEnv(void)
{
HINSTANCE	theCryptModule;
HINSTANCE	theAdvModule;

/* If the environment is already allocated, then we don't need to here */

	if (theCryptEnv != NULL)
        	return(OK);

/* First, we need to load the library */

        theCryptModuleIsPresent = NOTOK;

	if ((theCryptModule = LoadLibrary("crypt32.dll")) == NULL)
		return(NOTOK);
	if ((theAdvModule = LoadLibrary("advapi32.dll")) == NULL)
	{
                FreeLibrary(theCryptModule);
		return(NOTOK);
	}

/* Allocate space for the crypt module */

	if ((theCryptEnv = (CryptFuncEnv *)cp_malloc(sizeof(CryptFuncEnv))) == NULL)
        {
        	MENoMemory(DSPREPCRYPTENV);
                FreeLibrary(theCryptModule);
                FreeLibrary(theAdvModule);
                return(NOTOK);
        }

        theCryptEnv->theCryptModule = theCryptModule;
        theCryptEnv->theAdvModule = theAdvModule;

/* Now look up each function address */

	if ((theCryptEnv->CertRDNValueToStrProc = (CertRDNValueToStrProcType)GetProcAddress(
		theCryptModule, "CertRDNValueToStrA")) == NULL)
	{
                DSFreeCryptEnv();
		return(NOTOK);
	}
	if ((theCryptEnv->CertGetIssuerCertificateFromStoreProc = (CertGetIssuerCertificateFromStoreProcType)GetProcAddress(
		theCryptModule, "CertGetIssuerCertificateFromStore")) == NULL)
	{
                DSFreeCryptEnv();
		return(NOTOK);
	}
	if ((theCryptEnv->CryptAcquireContextProc = (CryptAcquireContextProcType)GetProcAddress(
		theAdvModule, "CryptAcquireContextA")) == NULL)
	{
                DSFreeCryptEnv();
		return(NOTOK);
	}
	if ((theCryptEnv->CertGetSubjectCertificateFromStoreProc = (CertGetSubjectCertificateFromStoreProcType)GetProcAddress(
		theCryptModule, "CertGetSubjectCertificateFromStore")) == NULL)
	{
                DSFreeCryptEnv();
		return(NOTOK);
	}
	if ((theCryptEnv->CertVerifyTimeValidityProc = (CertVerifyTimeValidityProcType)GetProcAddress(
		theCryptModule, "CertVerifyTimeValidity")) == NULL)
	{
                DSFreeCryptEnv();
		return(NOTOK);
	}
	if ((theCryptEnv->CertVerifySubjectCertificateContextProc =
                         (CertVerifySubjectCertificateContextProcType)GetProcAddress(
		              theCryptModule, "CertVerifySubjectCertificateContext")) == NULL)
	{
                DSFreeCryptEnv();
		return(NOTOK);
	}
	if ((theCryptEnv->CryptReleaseContextProc = (CryptReleaseContextProcType)GetProcAddress(
		theAdvModule, "CryptReleaseContext")) == NULL)
	{
                DSFreeCryptEnv();
		return(NOTOK);
	}
	if ((theCryptEnv->CertOpenSystemStoreProc = (CertOpenSystemStoreProcType)GetProcAddress(
		theCryptModule, "CertOpenSystemStoreA")) == NULL)
	{
                DSFreeCryptEnv();
		return(NOTOK);
	}
	if ((theCryptEnv->CertCloseStoreProc = (CertCloseStoreProcType)GetProcAddress(
		theCryptModule, "CertCloseStore")) == NULL)
	{
                DSFreeCryptEnv();
		return(NOTOK);
	}
	if ((theCryptEnv->CertFreeCertificateContextProc = (CertFreeCertificateContextProcType)GetProcAddress(
		theCryptModule, "CertFreeCertificateContext")) == NULL)
	{
                DSFreeCryptEnv();
		return(NOTOK);
	}
	if ((theCryptEnv->CryptSignMessageProc = (CryptSignMessageProcType)GetProcAddress(
		theCryptModule, "CryptSignMessage")) == NULL)
	{
                DSFreeCryptEnv();
		return(NOTOK);
	}
	if ((theCryptEnv->CryptVerifyDetachedMessageSignatureProc = (CryptVerifyDetachedMessageSignatureProcType)GetProcAddress(
		theCryptModule, "CryptVerifyDetachedMessageSignature")) == NULL)
	{
                DSFreeCryptEnv();
		return(NOTOK);
	}
	if ((theCryptEnv->CertEnumCertificatesInStoreProc = (CertEnumCertificatesInStoreProcType)GetProcAddress(
		theCryptModule, "CertEnumCertificatesInStore")) == NULL)
	{
                DSFreeCryptEnv();
		return(NOTOK);
	}
	if ((theCryptEnv->CertNameToStrProc = (CertNameToStrProcType)GetProcAddress(
		theCryptModule, "CertNameToStrA")) == NULL)
	{
                DSFreeCryptEnv();
		return(NOTOK);
	}
	if ((theCryptEnv->CryptDecodeObjectProc = (CryptDecodeObjectProcType)GetProcAddress(
		theCryptModule, "CryptDecodeObject")) == NULL)
	{
                DSFreeCryptEnv();
		return(NOTOK);
	}
	if ((theCryptEnv->CertCompareIntegerBlobProc = (CertCompareIntegerBlobProcType)GetProcAddress(
		theCryptModule, "CertCompareIntegerBlob")) == NULL)
	{
                DSFreeCryptEnv();
		return(NOTOK);
	}
	if ((theCryptEnv->CertFindRDNAttrProc = (CertFindRDNAttrProcType)GetProcAddress(
		theCryptModule, "CertFindRDNAttr")) == NULL)
	{
                DSFreeCryptEnv();
		return(NOTOK);
	}
	if ((theCryptEnv->CertGetCertificateContextPropertyProc =
             (CertGetCertificateContextPropertyProcType)GetProcAddress(
              theCryptModule, "CertGetCertificateContextProperty")) == NULL)
	{
                DSFreeCryptEnv();
		return(NOTOK);
	}
	if ((theCryptEnv->CertGetPublicKeyLengthProc =
             (CertGetPublicKeyLengthProcType)GetProcAddress(
              theCryptModule, "CertGetPublicKeyLength")) == NULL)
	{
                DSFreeCryptEnv();
		return(NOTOK);
	}

/* Finished */

        theCryptModuleIsPresent = OK;
	return(OK);
}

/**********************************************************************/
/* After checking all parameters for validity, this function will
	begin by obtaining the correct user certificate. Then, the
	certificate and the hash algorithm identifier are used to
	generate a signature for the message.

	@param msg UI - message content to be signed; can be binary

	@param msgLen NI - length of message content; if < 0, then it
		will be set equal to cp_strlen(msg), so obviously
		don't send binary unless you know the length.

        @param csp UI - identifies the cryptographic service provider to
        		use.  If NULL, the Microsoft Base Provider (defined by
                        MS_DEF_PROV) will be used.  Also, this string can
                        start with csptype=##\n to specify other provider
                        types than the default, which is PROV_RSA_FULL
                        (e.g. 2=RSA sig only, 3=DSS, 4=Fortezza).

	@param hashAlg UI - names the hash algorithm to be used.
		Currently, only "md5" and "sha1" can be used.

	@param signer UI - identifies which user certificate to use to
		sign the msg

	@param pSignature UO a pointer to the signature is returned
		through this parameter if the algorithm succeeds.

	@param pSignatureLen NO - the length of the signature is
		returned through this parameter

	@return N OK on success or an error code on failure

	@access private
*/
/**********************************************************************/

short DSSignMessage(charP msg, long msgLen, charP csp, charP hashAlg,
		    charP signer, charP *pSignature, long *pSignatureLen)
{
BYTE		*MessageArray[1];
DWORD		MessageSizeArray[1];
HCRYPTPROV	hCryptProv = 0;
HCERTSTORE	hMyStore;
PCCERT_CONTEXT	pSignerCert = NULL;
PCCERT_CONTEXT	MsgCertArray[1];
DWORD		HashAlgSize;
CRYPT_ALGORITHM_IDENTIFIER	HashAlgorithm;
CRYPT_SIGN_MESSAGE_PARA		SigParams;
DWORD		SigParamsSize = sizeof(SigParams);
DWORD		cbSignedMessageBlob = 0;
BYTE		*pbSignedMessageBlob;
short		theError;

/* Verify the input parameters */

	if (msg == NULL || hashAlg == NULL || signer == NULL ||
            pSignature == NULL || pSignatureLen == NULL)
	{
		MEInvalidParameters(DSSIGNMESSAGE);
		return(NOTOK);
	}

/* Make sure that the crypto API is available */

        if ((theError = DSPrepCryptEnv()) != OK)
        {
        	MELogErrorInfoStr(theError, DSSIGNMESSAGE, ME_INTERNALFUNCTIONFAILED, NULL);
                return(NOTOK);
        }

/* Set the output parameters to a known value */

	(*pSignature) = NULL;
	(*pSignatureLen) = 0;

/* If the msgLen was 0, then calculate the message length from the
	length of the message. */

	if (msgLen <= 0)
		msgLen = cp_strlen(msg);

/* Create the MessageArray (Step 2). */

	MessageArray[0] = (BYTE *) msg;
	MessageSizeArray[0] = msgLen;

/* Get a handle to a crytographic provider (Step 3).
	If the function succeeds, then the handle to the
	cryptographic provider resides at hCryptProv. */

	if ((theError = _DSCryptAcquireContext(
		&hCryptProv,			/* Address for handle to be returned. */
		NULL,				/* Use the current user's logon name. */
		csp,				/* The cryptographic service provider */
		0				/* No flags needed. */
		)) != OK)
	{
		MELogErrorInfoStr(theError, DSSIGNMESSAGE, ME_INTERNALFUNCTIONFAILED, NULL);
		return(NOTOK);
	}

/* Open a system certificate store (Step 4).
	If the call succeeds, the cert store handle will reside
	at the location pointed to by hMyStore. */

	if ((hMyStore = (*theCryptEnv->CertOpenSystemStoreProc)(hCryptProv, "MY")) == NULL)
	{
		MELogOSErrorStr(GetLastError(), DSSIGNMESSAGE, NULL);
		(void) (*theCryptEnv->CryptReleaseContextProc)(hCryptProv, 0);
		return(NOTOK);
	}

/* Get a pointer to the user's signature certificate (Step 5).
	Calls the GetMySignerCert() function. */

	if ((theError = _DSFindCertificate(hCryptProv, hMyStore, signer, &pSignerCert)) != OK)
	{
		MELogErrorInfoStr(theError, DSSIGNMESSAGE, DS_ERR_CERTNOTFOUND, signer);
		(void) (*theCryptEnv->CertCloseStoreProc)(hMyStore, CERT_CLOSE_STORE_CHECK_FLAG);
		(void) (*theCryptEnv->CryptReleaseContextProc)(hCryptProv, 0);
		return(NOTOK);
	}
	if (pSignerCert == NULL)
	{
		MELogErrorStr(0, DSSIGNMESSAGE, ME_INTERNALFUNCTIONFAILED, NULL);
		(void) (*theCryptEnv->CertCloseStoreProc)(hMyStore, CERT_CLOSE_STORE_CHECK_FLAG);
		(void) (*theCryptEnv->CryptReleaseContextProc)(hCryptProv, 0);
		return(NOTOK);
	}

/* Stop now if the signer's cert is expired */

	if ((*theCryptEnv->CertVerifyTimeValidityProc)(NULL, pSignerCert->pCertInfo) != 0)
        {
		MELogErrorStr(0, DSSIGNMESSAGE, DS_ERR_CERTEXPIRED, signer);
		(void) (*theCryptEnv->CertFreeCertificateContextProc)(pSignerCert);
		(void) (*theCryptEnv->CertCloseStoreProc)(hMyStore, CERT_CLOSE_STORE_CHECK_FLAG);
		(void) (*theCryptEnv->CryptReleaseContextProc)(hCryptProv, 0);
		return(NOTOK);
        }

/* Create a MsgCertArray (Step 6).
	It is possible to add any number of certificates to the
	signature.  Just make a larger MsgCertArray, put the
	certificates in successive elements here, then set the
	correct number into SigParams.cMsgCert below. */

	MsgCertArray[0] = pSignerCert;

/* Normally, at this point, additional certificates would be
	assigned to index locations within MsgCertArray. For the sake
	of clarity, this step is bypassed in this example, and only
	the signer's certificate in included with the message.
	(Step 7) */

/* Initialize the Algorithm Identifier structure (Step 8).
	Select MD5 or SHA1 based on hashAlg parameter */

	HashAlgSize = sizeof(HashAlgorithm);
	memset(&HashAlgorithm, 0, HashAlgSize);
	if (cp_strcmp(hashAlg, (charP) "md5") == OK)
		HashAlgorithm.pszObjId = szOID_RSA_MD5;
	else if (cp_strcmp(hashAlg, (charP) "sha1") == OK)
		HashAlgorithm.pszObjId = szOID_RSA_SHA1RSA;
	else
	{
		MELogErrorStr(0, DSSIGNMESSAGE, DS_ERR_INVALIDHASHALG, hashAlg);
		(void) (*theCryptEnv->CertFreeCertificateContextProc)(pSignerCert);
		(void) (*theCryptEnv->CertCloseStoreProc)(hMyStore, CERT_CLOSE_STORE_CHECK_FLAG);
		(void) (*theCryptEnv->CryptReleaseContextProc)(hCryptProv, 0);
		return(NOTOK);
	}

/*  Initialize the signature structure (Step 9). */

	memset(&SigParams, 0, SigParamsSize);

	SigParams.cbSize = SigParamsSize;
	SigParams.dwMsgEncodingType = X509_ASN_ENCODING | PKCS_7_ASN_ENCODING;
	SigParams.pSigningCert = pSignerCert;
	SigParams.HashAlgorithm = HashAlgorithm;
	SigParams.cMsgCert = 1;
	SigParams.rgpMsgCert = MsgCertArray;

/*	SigParams.cMsgCert = 0; */
/*	SigParams.rgpMsgCert = NULL; */
/* Use 0 and NULL if you don't want any certs. in your signature; this makes
	them smaller, but it means you need to rewrite the callback function
        _DSGetVerificationCertificate() to dig up the signer's cert. on the
        verifier's box.  If it is there, a likely place to look is in Outlook
        Express's ADDRESSBOOK certificate store */

/* Sign the message.
	JB: We use 'detached' because we just want the signed hash.  We
	don't want the actual message to be encoded into the
	signed message blob. */

	if ((*theCryptEnv->CryptSignMessageProc)(&SigParams,	/* Signature parameters */
		TRUE,				/* Detached */
		1,				/* Number of messages */
		MessageArray,			/* Messages to be signed */
		MessageSizeArray,		/* Size of messages */
		NULL,				/* Buffer for signed msg */
		&cbSignedMessageBlob		/* Size of buffer */
		) != TRUE)
	{
		MELogOSErrorStr(GetLastError(), DSSIGNMESSAGE, NULL);
		(void) (*theCryptEnv->CertFreeCertificateContextProc)(pSignerCert);
		(void) (*theCryptEnv->CertCloseStoreProc)(hMyStore, CERT_CLOSE_STORE_CHECK_FLAG);
		(void) (*theCryptEnv->CryptReleaseContextProc)(hCryptProv, 0);
		return(NOTOK);
	}

/* Allocate memory for the signed blob. */

	if ((pbSignedMessageBlob = (BYTE *) cp_malloc(cbSignedMessageBlob)) == NULL)
	{
		MENoMemory(DSSIGNMESSAGE);
		(void) (*theCryptEnv->CertFreeCertificateContextProc)(pSignerCert);
		(void) (*theCryptEnv->CertCloseStoreProc)(hMyStore, CERT_CLOSE_STORE_CHECK_FLAG);
		(void) (*theCryptEnv->CryptReleaseContextProc)(hCryptProv, 0);
		return(NOTOK);
	}

	memset(pbSignedMessageBlob, 0, cbSignedMessageBlob);

/* Get the SignedMessageBlob. */

	if ((*theCryptEnv->CryptSignMessageProc)(&SigParams,	/* Signature parameters */
		TRUE,				/* Detached */
		1,				/* Number of messages */
		MessageArray,			/* Messages to be signed */
		MessageSizeArray,		/* Size of messages */
		pbSignedMessageBlob,		/* Buffer for signed msg */
		&cbSignedMessageBlob		/* Size of buffer */
		) != TRUE)
	{
		MELogOSErrorStr(GetLastError(), DSSIGNMESSAGE, NULL);
		cp_free((charP)pbSignedMessageBlob);
		(void) (*theCryptEnv->CertFreeCertificateContextProc)(pSignerCert);
		(void) (*theCryptEnv->CertCloseStoreProc)(hMyStore, CERT_CLOSE_STORE_CHECK_FLAG);
		(void) (*theCryptEnv->CryptReleaseContextProc)(hCryptProv, 0);
		return(NOTOK);
	}

/* Clean up & return */

	(void) (*theCryptEnv->CertFreeCertificateContextProc)(pSignerCert);
	(void) (*theCryptEnv->CertCloseStoreProc)(hMyStore, CERT_CLOSE_STORE_CHECK_FLAG);
	(void) (*theCryptEnv->CryptReleaseContextProc)(hCryptProv, 0);

	(*pSignature) = (charP) pbSignedMessageBlob;
	(*pSignatureLen) = (long) cbSignedMessageBlob;

	return(OK);
}

/**********************************************************************/
/* This function verifies that the hash value of the given message
	is equal to the one stored in the signature.  It also tests
        the signature certificate for a number of error conditions
        (e.g. expired).  Finally, it also obtains the demographic
        data on the certificates in the chain of issuance from (and
        including) the signer's certificate up to the root certificate
        authority.
	Note: the blob of data pointed to by signature contains an
		indication of which hash algorithm was used to create it.

	@param msg UI - message content to be verified

	@param msgLen NI - length of message content; if < 0, then it
		will be set equal to cp_strlen(msg), so obviously don't
		send binary unless you know the length.

        @param csp UI - identifies the cryptographic service provider to
        		use.  If NULL, the Microsoft Base Provider (defined by
                        MS_DEF_PROV) will be used.  Also, this string can
                        start with csptype=##\n to specify other provider
                        types than the default, which is PROV_RSA_FULL
                        (e.g. 2=RSA sig only, 3=DSS, 4=Fortezza).

	@param signature UI - a signature supposedly created by the
		signer which must match the contents of msg once the
		signature is decoded using the signer's public key.

	@param signatureLen NI - the length of the signature data

	@param pSigner UO - gives the common name and email address of the
        			signer.  Pass NULL if you don't want this

	@param pCertInfo UO - returns a text description of additional
                certificate information.  One piece of information is stored
                per line.  Current info includes key length and expiry date.
                The lines start with "Key length" and "Not after".

	@param pCertChain UO - returns a text description of the chain
		of issuance for the signer's certificate.  Send NULL if you
                don't need the certificate chain text description

	@param pVerifyStatus NO - Returns the result of the attempt to
		verify the digital signature.  The following codes may be
                OR'd together.

        DS_CERTNOTTRUSTED
        	if the certificate is marked as untrusted on the system
                (this is not implemented because it is application-specific)

	DS_CERTEXPIRED
		if the certificate's time validity check fails

	DS_CERTREVOKED
                if the certificate is in the issuer's CRL

	DS_ISSUERSIGFAILED
		if the issuer signature on the certificate fails

	DS_ISSUERCERTNOTFOUND
                if the issuer certificate not found on local machine

	DS_MSG_CERTNOTFOUND
		if the message certificate is not found

	DS_MSG_ALTERED
                The signature hash doesn't match the message hash

	OK  if all tests passed

	@return N OK on success, NOTOK on internal failure.
        	  Note that the success of the function is different from
                  the success of the verify.  You must check the value
                  returned in pVerifyStatus.

	@access private
*/
/**********************************************************************/

short DSVerifySignature(charP msg, long msgLen, charP csp,
			charP signature, long signatureLen,
			charP *pSigner, charP *pCertInfo, charP *pCertChain,
                        short *pVerifyStatus)
{
HCRYPTPROV		hCryptProv = 0;
DSUserDataForVerify	theVerifyData;
CRYPT_VERIFY_MESSAGE_PARA	VerifyParams;
DWORD			tempLen;
short			theError;

/* Set the output parameters to known values */

	if (pVerifyStatus != NULL) *pVerifyStatus = OK;
	if (pCertChain != NULL) *pCertChain = NULL;
        if (pCertInfo != NULL) *pCertInfo = NULL;
        if (pSigner != NULL) *pSigner = NULL;

/* Verify the input parameters */

	if (msg==NULL || signature==NULL || signatureLen<=0 || pVerifyStatus==NULL)
	{
		MEInvalidParameters(DSVERIFYSIGNATURE);
		return(NOTOK);
	}

/* We try to compute the message length if it isn't given */

	if (msgLen <= 0)
		msgLen = cp_strlen(msg);

/* Make sure that the crypto API is available */

        if ((theError = DSPrepCryptEnv()) != OK)
        {
        	MELogErrorInfoStr(theError, DSVERIFYSIGNATURE, ME_INTERNALFUNCTIONFAILED, NULL);
                return(NOTOK);
        }

/* Get a handle to a cryptographic provider. */

	if ((theError = _DSCryptAcquireContext(
		&hCryptProv,			/* Address for handle to be returned. */
		NULL,				/* Use the current user's logon name. */
		csp,				/* The cryptographic service provider */
		CRYPT_VERIFYCONTEXT		/* Only need verify functionality. */
		)) != OK)
	{
		MELogErrorInfoStr(theError, DSVERIFYSIGNATURE, ME_INTERNALFUNCTIONFAILED, NULL);
		return(NOTOK);
	}

/* Set up the extra data needed by the verify callback function */

	theVerifyData.hCryptProv = hCryptProv;
	theVerifyData.signer = NULL;
	theVerifyData.signature = signature;
	theVerifyData.signatureLen = signatureLen;
	theVerifyData.msg = msg;
	theVerifyData.msgLen = msgLen;
	theVerifyData.CertInfo = NULL;
	theVerifyData.CertChain = NULL;
	theVerifyData.result = 0;

/* Initialize the CRYPT_VERIFY_MESSAGE_PARA structure.
	Also, see the _DSGetSignerCertificate() function */

	memset(&VerifyParams, 0, sizeof(VerifyParams));

	VerifyParams.cbSize = sizeof(VerifyParams);
	VerifyParams.dwMsgAndCertEncodingType = X509_ASN_ENCODING | PKCS_7_ASN_ENCODING;
	VerifyParams.hCryptProv = hCryptProv;
	VerifyParams.pfnGetSignerCertificate = _DSGetVerificationCertificate;
	VerifyParams.pvGetArg = &theVerifyData;

/* Call CryptVerifyDetachedMessageSignature to verify a detached signature. */

	tempLen = msgLen;
	if ((*theCryptEnv->CryptVerifyDetachedMessageSignatureProc)(&VerifyParams, 0,
		(const byte *)signature, signatureLen, 1, &msg, &tempLen, NULL) != TRUE)
	{
        DWORD   lastError = GetLastError();

		/* If you're getting a compiler error here, then you're getting
                	your compiler's copy of winerror.h, not the one in this
                        directory.  Your compiler isn't properly processing the
                        quotes around winerror.h, which are supposed to cause
                        the local copy to be taken first.  Put .\; before your
                        compiler's include directories in your path settings to
                        fix this problem.
                   Also, if your compiler claims that this constant is out of
                        range, it isn't and the comparison works. */

                /* Compiler error or warning here... see above */
                if (lastError == NTE_BAD_SIGNATURE)
                     theVerifyData.result |= DS_MSG_ALTERED;
		else
                {
			(*pVerifyStatus) = theVerifyData.result;
                	MELogOSErrorStr(lastError, DSVERIFYSIGNATURE, NULL);
			(void) (*theCryptEnv->CryptReleaseContextProc)(hCryptProv, 0);
			return NOTOK;
                }
	}

/* Finished */

	(*pVerifyStatus) = theVerifyData.result;

        if (pSigner != NULL)
                *pSigner = theVerifyData.signer;
        else    cp_free(theVerifyData.signer);

        if (pCertInfo != NULL)
                *pCertInfo = theVerifyData.CertInfo;
        else    cp_free(theVerifyData.CertInfo);

	if (pCertChain != NULL)
		*pCertChain = theVerifyData.CertChain;
	else	cp_free(theVerifyData.CertChain);

	(void) (*theCryptEnv->CryptReleaseContextProc)(hCryptProv, 0);

	return(OK);
}

/**********************************************************************/
/* This function searches the certificates for a match on the
	substring parameter. A list is constructed of all matches.
	Each element in the list will contain "Common Name, Email".

        @param csp UI - identifies the cryptographic service provider to
        		use.  If NULL, the Microsoft Base Provider (defined by
                        MS_DEF_PROV) will be used.  Also, this string can
                        start with csptype=##\n to specify other provider
                        types than the default, which is PROV_RSA_FULL
                        (e.g. 2=RSA sig only, 3=DSS, 4=Fortezza).

	@param substring UI - The subject of the certificate must contain
		this substring to be included in the list. Typically
		this will be the email address or the personal identity
		portion of the common name (e.g. the "John Boyer" part
 		of "Manager John Boyer" and "Employee John Boyer").
		If NULL is passed, then all identities in the store are
		returned.

        @param OnlyValidCerts NI - send OK to restrict list to valid certs.
                matching the substring.  Send NOTOK for all certs. matching
                the substring.
                In a typical dig.sig.app. try OK first.  If that fails, then
                try NOTOK.  If you still get nothing, then the user needs to
                get a cert. from a CA.  If the second call produces a result,
                then tell the user that his/her cert. has expired.

	@param listPtr UO - a pointer to where to store the list of
		identities. Each element will contain "Common Name, Email"
		from the "MY" certificate store. This list can be
		destroyed with the cp_freelist() function. If NULL is
		passed then the list is not constructed.

	@param listSizePtr NO - a pointer to where to store the number
		of entries in the above list.

	@return N OK on success or an error code on failure

	@access public
*/
/**********************************************************************/

short DSGetIdentityList(charP csp, charP substring, short OnlyValidCerts,
			charP **listPtr, short *listSizePtr)
{
HCRYPTPROV		hCryptProv = 0;
HCERTSTORE		hStoreHandle;
charP			*theList = NULL;
charP			*tempList;
short			theListCount = 0, I;
PCCERT_CONTEXT		pCertContext;
charP			CertSubject = NULL;
short			theError;
BOOL			FoundIdentity;

/* Verify the input parameters */

	if (listSizePtr == NULL)
	{
		MEInvalidParameters(DSGETIDENTITYLIST);
		return(NOTOK);
	}

/* Make sure that the crypto API is available */

        if ((theError = DSPrepCryptEnv()) != OK)
        {
        	MELogErrorInfoStr(theError, DSGETIDENTITYLIST, ME_INTERNALFUNCTIONFAILED, NULL);
                return(NOTOK);
        }

/* Set the output parameters to a known value */

	if (listPtr != NULL)
		(*listPtr) = NULL;
	(*listSizePtr) = 0;

/* Get a handle to a crytographic provider (Step 3).
	If the function succeeds, then the handle to the
	cryptographic provider resides at hCryptProv. */

	if ((theError = _DSCryptAcquireContext(
		&hCryptProv,			/* Address for handle to be returned. */
		NULL,				/* Use the current user's logon name. */
		csp,				/* The cryptographic service provider */
		CRYPT_VERIFYCONTEXT		/* Don't need private key access. */
		)) != OK)
	{
		MELogErrorInfoStr(theError, DSGETIDENTITYLIST, ME_INTERNALFUNCTIONFAILED, NULL);
		return(NOTOK);
	}

/* Open a system certificate store (Step 4).
	If the call succeeds, the cert store handle will reside
	at the location pointed to by hStoreHandle. */

	if ((hStoreHandle = (*theCryptEnv->CertOpenSystemStoreProc)(hCryptProv, "MY")) == NULL)
	{
		MELogOSErrorStr(GetLastError(), DSGETIDENTITYLIST, NULL);
		(void) (*theCryptEnv->CryptReleaseContextProc)(hCryptProv, 0);
		return(NOTOK);
	}

/* Now we want to loop through all certificates in the store,
	appending the Subject line of each to theList. */

	pCertContext = NULL;
	while ((pCertContext = (*theCryptEnv->CertEnumCertificatesInStoreProc)(hStoreHandle, pCertContext)) != NULL)
	{

/* Get the Subject of the certificate */

		if ((theError = _DSGetSubjectFromCert(pCertContext, &CertSubject, NOTOK)) != OK)
		{
			MELogErrorInfoStr(theError, DSGETIDENTITYLIST, ME_INTERNALFUNCTIONFAILED, NULL);
			cp_freelist(&theList, theListCount);
			(void) (*theCryptEnv->CertFreeCertificateContextProc)(pCertContext);
			(void) (*theCryptEnv->CertCloseStoreProc)(hStoreHandle, CERT_CLOSE_STORE_CHECK_FLAG);
			(void) (*theCryptEnv->CryptReleaseContextProc)(hCryptProv, 0);
			return(theError);
		}
		if (CertSubject == NULL)
			continue;

/* If the subject certificate is invalid, then we ignore it */

                if (OnlyValidCerts==OK && _DSCheckCertificate(pCertContext, hCryptProv) != OK)
                    ;

/* Don't want to list certificates that don't have a signature keypair
	(Note that code in _DSTestSignatureProperty() is commented out
        because the CA's are not issuing certs. with this property set) */

                else if (_DSTestSignatureProperty(pCertContext) != OK)
                    ;

/* If this subject matches what we are looking for, then add it to the list */

		else if (substring == NULL || cp_strstr(CertSubject, substring))
		{
/* If the identity is already in the list, then don't add it again.  If a user
        has a certificate near expiry, the user can get a new certificate under
        the same name and only one identity will show up in the list.  In
        DSSignMessage, we choose the first match to the signing identity, so
        the newest certificate always gets used because the CSPs put newer
        certificates before older ones in the certificate stores.  Also, if
        a user with a 512 bit trial certificate upgrades to a 1024 bit paid
        certificate, again the newer one gets used. */

                        for (I = 0, FoundIdentity=FALSE; I < theListCount; I++)
                             if (theList!=NULL && cp_strcmp(theList[I], CertSubject)==OK)
                                 FoundIdentity = TRUE;

                        if (FoundIdentity)
                            ;

/* If it's unique, add the new identity to the list */

                        else
                        {
			   theListCount++;
			   if (listPtr != NULL)
			   {
				if ((tempList = (charP *)cp_realloc((charP)theList, sizeof(charP) * theListCount,
					sizeof(charP) * (theListCount - 1))) == NULL)
				{
					MENoMemory(DSGETIDENTITYLIST);
					cp_free(CertSubject);
					theListCount--;
					cp_freelist(&theList, theListCount);
					(void) (*theCryptEnv->CertFreeCertificateContextProc)(pCertContext);
					(void) (*theCryptEnv->CertCloseStoreProc)(hStoreHandle, CERT_CLOSE_STORE_CHECK_FLAG);
					(void) (*theCryptEnv->CryptReleaseContextProc)(hCryptProv, 0);
					return(NOTOK);
				}
				theList = tempList;
				theList[theListCount-1] = CertSubject;
				CertSubject = NULL;
                           }
			}
		}

		cp_free(CertSubject);
                CertSubject = NULL;
	}

/* Cleanup */

	(void) (*theCryptEnv->CertCloseStoreProc)(hStoreHandle, CERT_CLOSE_STORE_CHECK_FLAG);
	if ((*theCryptEnv->CryptReleaseContextProc)(hCryptProv, 0) != TRUE)
	{
		cp_freelist(&theList, theListCount);
		MELogOSErrorStr(GetLastError(), DSGETIDENTITYLIST, NULL);
		return(NOTOK);
	}

/* Return values */

	(*listSizePtr) = theListCount;
	if (listPtr != NULL)
		(*listPtr) = theList;

	return(OK);
}

/**********************************************************************/
/* This is a diagnostic function for inspecting the contents of a
	given certificate store.

        @param csp UI - identifies the cryptographic service provider to
        		use.  If NULL, the Microsoft Base Provider (defined by
                        MS_DEF_PROV) will be used.  Also, this string can
                        start with csptype=##\n to specify other provider
                        types than the default, which is PROV_RSA_FULL
                        (e.g. 2=RSA sig only, 3=DSS, 4=Fortezza).

	@param certStoreName UI - the name of the certificate store
		whose contents the caller would like to list.

	@param wholeSubject NI - use NOTOK to get just the common name
		and email of each certificate (certs. not having these
		are omitted from the list). use OK to get the whole
		subject field converted to a string (the whole
		certificate contains other info about the organization,
		country, issuer, etc.)

	@param theCertificatePtr UO - a pointer to where to store the
		information about the certificates. Each is separated
		by two \n characters.

	@return N OK on success or an error code on failure

	@access protected
*/
/**********************************************************************/

short DSGetCertList(charP csp, charP certStoreName, short wholeSubject,
			     charP *theCertificatePtr)
{
HCRYPTPROV		hCryptProv = 0;
HCERTSTORE		hStoreHandle;
charP			theList;
charP			tempList;
PCCERT_CONTEXT		pCertContext;
charP			CertSubject = NULL;
short			theError;

/* Verify the input parameters */

	if (certStoreName == NULL ||
            (wholeSubject != OK	&& wholeSubject != NOTOK) ||
            theCertificatePtr == NULL)
	{
		MEInvalidParameters(DSGETCERTLIST);
		return(NOTOK);
	}

/* Make sure that the crypto API is available */

        if ((theError = DSPrepCryptEnv()) != OK)
        {
        	MELogErrorInfoStr(theError, DSGETCERTLIST, ME_INTERNALFUNCTIONFAILED, NULL);
                return(NOTOK);
        }

/* Set the output parameters to a known value */

	(*theCertificatePtr) = NULL;

/* Get a handle to a crytographic provider (Step 3).
	If the function succeeds, then the handle to the
	cryptographic provider resides at hCryptProv. */

	if ((theError = _DSCryptAcquireContext(
		&hCryptProv,			/* Address for handle to be returned. */
		NULL,				/* Use the current user's logon name. */
		csp,				/* The cryptographic service provider */
		CRYPT_VERIFYCONTEXT		/* Don't need private key access */
		)) != OK)
	{
		MELogErrorInfoStr(theError, DSGETCERTLIST, ME_INTERNALFUNCTIONFAILED, NULL);
		return(NOTOK);
	}

/* Open a system certificate store (Step 4).
	If the call succeeds, the cert store handle will reside
	at the location pointed to by hStoreHandle. */

	if ((hStoreHandle = (*theCryptEnv->CertOpenSystemStoreProc)(hCryptProv, certStoreName)) == NULL)
	{
		MELogOSErrorStr(GetLastError(), DSGETCERTLIST, NULL);
		(void) (*theCryptEnv->CryptReleaseContextProc)(hCryptProv, 0);
		return(NOTOK);
	}

/* Now we want to loop through all certificates in the store,
	appending the Subject line of each to theList. */

	if ((theList = cp_malloc(1)) == NULL)
	{
		MENoMemory(DSGETCERTLIST);
		(void) (*theCryptEnv->CryptReleaseContextProc)(hCryptProv, 0);
		return(NOTOK);
	}
	theList[0] = '\0';
	
	pCertContext = NULL;
	while ((pCertContext = (*theCryptEnv->CertEnumCertificatesInStoreProc)(hStoreHandle, pCertContext)) != NULL)
	{

/* Get the Subject of the certificate */

		if ((theError = _DSGetSubjectFromCert(pCertContext, &CertSubject, wholeSubject)) != OK)
		{
			MELogErrorInfoStr(theError, DSGETCERTLIST, ME_INTERNALFUNCTIONFAILED, NULL);
			cp_free(theList);
			(void) (*theCryptEnv->CertFreeCertificateContextProc)(pCertContext);
			(void) (*theCryptEnv->CryptReleaseContextProc)(hCryptProv, 0);
			return(NOTOK);
		}
		if (CertSubject == NULL)
			continue;

/* Append subject to list */

		if ((tempList = cp_realloc(theList,
                                           cp_strlen(theList)+2*cp_strlen(LINE_DELIMITER)+cp_strlen(CertSubject)+1,
			                   cp_strlen(theList)+1+16)) == NULL)
		{
			MENoMemory(DSGETCERTLIST);
			cp_free(theList);
			(void) (*theCryptEnv->CertFreeCertificateContextProc)(pCertContext);
			(void) (*theCryptEnv->CryptReleaseContextProc)(hCryptProv, 0);
			return(NOTOK);
		}
		theList = tempList;
		cp_strcat(theList, CertSubject);
		cp_strcat(theList, LINE_DELIMITER);
		cp_strcat(theList, LINE_DELIMITER);
                cp_free(CertSubject);
                CertSubject = NULL;
	}

/* Finished */

	(void) (*theCryptEnv->CertCloseStoreProc)(hStoreHandle, CERT_CLOSE_STORE_CHECK_FLAG);
	(void) (*theCryptEnv->CryptReleaseContextProc)(hCryptProv, 0);

	(*theCertificatePtr) = theList;

	return(OK);
}


