#ifndef __DS_LIB_H__
#define __DS_LIB_H__

/*
Copyright (c) 1998 by UWI Unisoft Wares Inc.
   UWI.Com -- The Internet Forms Company
   400 - 1095 McKenzie Ave.
   Victoria, British Columbia Canada V8P 2L5
   1-888-517-2675
   http://www.uwi.com

Author: John Boyer

Neither John Boyer, UWI Unisoft Wares Inc., nor Dr. Dobb's Journal will be
   liable under any circumstances for any direct or indirect damages arising
   from any use, direct or indirect, of this software. This software is
   provided with no warranty, implicit or explicit.

UWI Unisoft Wares Inc. grants you license to use this software in your programs
under the following conditions:
1) This copyright and license message must remain in this source code.
2) The following copyright message must appear in the program credits and
        documentation acknowledgements of software containing this library

   The Digital Signature Library for Microsoft(R) CryptoAPI
   Written By John Boyer Copyright (c) 1998 by UWI Unisoft Wares Inc.
*/

#ifdef __cplusplus
extern "C" {
#endif

#define OK	0
#define NOTOK	-1

#define LINE_DELIMITER	"\r\n"

#include "charp.h"

#define DS_CERTNOTTRUSTED	128
#define DS_CERTEXPIRED		64
#define DS_CERTREVOKED		32
#define DS_ISSUERSIGFAILED	16
#define DS_ISSUERCERTNOTFOUND	8
#define DS_MSG_CERTNOTFOUND	2
#define DS_MSG_ALTERED		1

extern short theCryptModuleIsPresent;

/**********************************************************************/
short DSPrepCryptEnv(void);
void  DSFreeCryptEnv(void);

/**********************************************************************/
short DSSignMessage(charP msg, long msgLen,
		      charP csp, charP hashAlg,	charP signer,
		      charP *pSignature, long *pSignatureLen);

/**********************************************************************/
short DSVerifySignature(charP msg, long msgLen, charP csp,
			  charP signature, long signatureLen,
			  charP *pSigner, charP *pCertInfo, charP *pCertChain,
                          short *pCertStatus);

/**********************************************************************/
short DSGetIdentityList(charP csp, charP substring, short OnlyValidCerts,
			charP **listPtr, short *listSizePtr);

/**********************************************************************/
short DSGetCertList(charP csp,	charP certStoreName, short wholeSubject,
		    charP *theCertificatePtr);

/**********************************************************************/

#ifdef __cplusplus
}
#endif

#endif
