/* *** dserror.c ***

Copyright (c) 1998 by UWI Unisoft Wares Inc.
   UWI.Com -- The Internet Forms Company 
   400 - 1095 McKenzie Ave.
   Victoria, British Columbia Canada V8P 2L5
   1-888-517-2675
   http://www.uwi.com

Author: John Boyer

Neither John Boyer, UWI Unisoft Wares Inc., nor Dr. Dobb's Journal will be
   liable under any circumstances for any direct or indirect damages arising
   from any use, direct or indirect, of this software. This software is
   provided with no warranty, implicit or explicit.

UWI Unisoft Wares Inc. grants you license to use this software in your programs
under the following conditions:
1) This copyright and license message must remain in this source code.
2) The following copyright message must appear in the program credits and
        documentation acknowledgements of software containing this library

   The Digital Signature Library for Microsoft(R) CryptoAPI
   Written By John Boyer Copyright (c) 1998 by UWI Unisoft Wares Inc.
*/

/*
This is a severely pared down version of an error system that would take far
too long to explain and require the inclusion of more tangential code.  Basically
this is a decent error handler that can be used until you hook this code
into your own error handling system.
*/

#include "dserror.h"
#include <windows.h>
#include <stdio.h>

charP FunctionStrings[] =
{
        "DSFreeCryptEnv",
	"DSPrepCryptEnv",
	"DSSignMessage",
	"DSVerifySignature",
	"DSGetIdentityList",
        "DSGetCertList",
	"_DSGetSubjectFromCert",
        "_DSFindRDNAttr",
        "_DSFindCertificate",
        "_DSGetIssuerCert",
        "_DSGetCertChain",
        "_DSCryptAcquireContext",
        "_DSGetVerificationCertificate",
        "_DSCheckCertificate",
        "_DSTestSignatureProperty"
};

charP ErrorStrings[] =
{
        "",
	"Invalid Parameters",
	"Out of Memory",
	"Internal Function failed",
	"Operating System Error#",
	"Invalid Hash Algorithm Identifier",
        "Certificate Not Found",
        "Certificate Expired"
};

void MELogError(int lastError, int FunctionCode, int LineNum, int ErrorCode, charP ErrorInfo)
{
char Line[256];

     sprintf(Line, "%s(%d): %s %s %X", FunctionStrings[FunctionCode], LineNum,
     				       ErrorStrings[ErrorCode],
     				       ErrorInfo?ErrorInfo:"",
                                       lastError);

     MessageBox(NULL, Line, "Error reported by Digital Signature Library", 0);
}


