/*
Copyright (c) 1998 by UWI Unisoft Wares Inc.
   UWI.Com -- The Internet Forms Company
   400 - 1095 McKenzie Ave.
   Victoria, British Columbia Canada V8P 2L5
   1-888-517-2675
   http://www.uwi.com

Author: John Boyer

Neither John Boyer, UWI Unisoft Wares Inc., nor Dr. Dobb's Journal will be
   liable under any circumstances for any direct or indirect damages arising
   from any use, direct or indirect, of this software. This software is
   provided with no warranty, implicit or explicit.

UWI Unisoft Wares Inc. grants you license to use this software in your programs
under the following conditions:
1) This copyright and license message must remain in this source code.
2) The following copyright message must appear in the program credits and
        documentation acknowledgements of software containing this library

   The Digital Signature Library for Microsoft(R) CryptoAPI
   Written By John Boyer Copyright (c) 1998 by UWI Unisoft Wares Inc.
*/

// NOTE:  If you're having trouble compiling this, esp. under Windows 95,
//        then make sure you have the latest wincrypt.h and winerror.h from
//        the Jan.98 release of the Microsoft Platform SDK.  Then, go into
//        wincrypt.h and comment out the #if(_WIN32_WINNT >= 0x0400) and its
//        corresponding #endif.

#include <windows.h>
#include "ds_lib.h"
#include <stdio.h>
#pragma hdr_stop

void ShowCertificateLists(void);
void GetTheMessage(charP *pMsg, long *pMsgLen);

int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, char far* cmdLine, int cmdShow)
{
charP theSignature;
long theSignatureLen;
char Line[200];
short VerifyStatus=OK;
charP CertInfo=NULL, CertChain=NULL, signer=NULL, emailAddr=NULL;
charP *list=NULL;
short n=0;
charP Msg = NULL;
long  MsgLen = 0;

    GetTheMessage(&Msg, &MsgLen);
    if (Msg==NULL)
    {
        MessageBox(NULL, "Out of memory", NULL, MB_TASKMODAL); 
        return 0;
    }

/* Are the CryptoAPI DLLs available on this box? */

    if (DSPrepCryptEnv() != OK)
    {
        MessageBox(NULL, "CryptoAPI not available on this machine", NULL, 0);
        return 0;
    }

/* This just shows you the contents of all your certificate stores */

    ShowCertificateLists();

/* Now we get the list of identities for your email address, and pick the
	first signer identity (this is just the choice in this demo program;
        you can use any of the identities to create a signature).

        NOTE: You have to get YOUR email address in here for this code to
        	work with your certificates!! */

    emailAddr = "jboyer@uwi.com";
    if (DSGetIdentityList(NULL, emailAddr, OK, &list, &n) != OK)
        MessageBox(NULL, "DSGetIdentityList Failed", NULL, MB_TASKMODAL);
    else if (list==NULL || n==0)
    {
         DSGetIdentityList(NULL, emailAddr, NOTOK, &list, &n);
         if (list==NULL || n==0)
              MessageBox(NULL, emailAddr, "NO CERTIFICATES FOR", MB_TASKMODAL);
         else MessageBox(NULL, emailAddr, "CERTIFICATE EXPIRED FOR", MB_TASKMODAL);
         cp_freelist(&list, n);
    }

    if (list==NULL || n==0)
    {
         DSFreeCryptEnv();
         return 0;
    }

    signer = list[0];

/* The chosen signer must be taken out of the list before calling cp_freelist()
	or else the signer string will get freed */

    list[0] = NULL;
    cp_freelist(&list, n);

/* Now we sign some simple text.  signer contains a string of the
		form "John1 M Boyer, jboyer@uwi.com" */

    if (DSSignMessage(Msg, MsgLen, NULL, "sha1", signer,
                      &theSignature, &theSignatureLen) != OK)
    {
         MessageBox(NULL, "DSSignMessage Failed", NULL, MB_TASKMODAL);
         DSFreeCryptEnv();
         return 0;
    }
    else MessageBox(NULL, signer,
                    "DSSignMessage succeeded with identity below", MB_TASKMODAL);

    cp_free(signer);
    signer = NULL;

/**** Now theSignature contains a binary representation of the signer's
	certificate plus the signed hash of the given message ****/

    if (DSVerifySignature(Msg, MsgLen, NULL,
                          theSignature, theSignatureLen,
                          &signer, &CertInfo, &CertChain, &VerifyStatus) != OK)
         MessageBox(NULL, "DSVerifySignature Failed", NULL, MB_TASKMODAL);
    else MessageBox(NULL, "DSVerifySignature Succeeded", "NOTE", MB_TASKMODAL);

// Show stats from the verify; If VerifyStatus is anything but 0, then the
// digital signature is not to be trusted.  For example, suppose everything
// checks out except we couldn't find the issuer certificate on the verifying
// box.  You can't trust the signature even if the computed hash matches
// the encrypted hash because the signer certificate may have been altered
// by 'the bad guys' as part of the attempt to fool the verifier.

    sprintf(Line, "Signer=%s\r\nVerifyStatus=%hd, sigsize=%d, sig=%-50s",
                   signer, VerifyStatus, theSignatureLen, theSignature);
    MessageBox(NULL, Line, "The Signature", MB_TASKMODAL);
    MessageBox(NULL, CertInfo?CertInfo:"No info",
               "The Certificate Info from the signing certificate", MB_TASKMODAL);
    MessageBox(NULL, CertChain?CertChain:"Not built",
               "The Certificate Chain of the signing certificate", MB_TASKMODAL);

    cp_free(signer);
    cp_free(CertInfo);
    cp_free(CertChain);

// Demonstrate message altered error

    if (DSVerifySignature("A Different Secret Message", 0, NULL,
                          theSignature, theSignatureLen,
                          NULL, NULL, NULL, &VerifyStatus) != OK)
         MessageBox(NULL, "DSVerifySignature Internal Failure", NULL, MB_TASKMODAL);

    else if (VerifyStatus != OK)
    {
         sprintf(Line, "DSVerifySignature failed(%d) and was supposed to", VerifyStatus);
         MessageBox(NULL, Line, "NOTE", MB_TASKMODAL);
    }
    else MessageBox(NULL, "DSVerifySignature Succeeded and wasn't supposed to", NULL, MB_TASKMODAL);

// Clean up and terminate

    cp_free(theSignature);
    cp_free(Msg);

    DSFreeCryptEnv();

    return 0;
}

//===========================================================================
//===========================================================================

void GetTheMessage(charP *pMsg, long *pMsgLen)
{
FILE *Infile;
long theSize;
charP Buffer;

     Infile = fopen("ds_lib.c", "rb");
     if (Infile == NULL)
     {
         MessageBox(NULL, "Couldn't open file; using string message",
                    NULL, MB_TASKMODAL);
         *pMsg = cp_strdup("The Secret Message");
         *pMsgLen = 0;
         return;
     }
     theSize = filelength(fileno(Infile));
     Buffer = (char *) malloc(theSize);
     if (Buffer != NULL)
         fread(Buffer, theSize, 1, Infile);
     fclose(Infile);

     *pMsg = Buffer;
     *pMsgLen = theSize;
}

//===========================================================================
//===========================================================================

void ShowCertificateLists(void)
{
charP theList;
//FILE *Outfile;

    DSGetCertList(NULL, "MY", OK, &theList);
    MessageBox(NULL, theList?theList:"NULL", "MY CertStore Contents", MB_TASKMODAL);
//    Outfile = fopen("MY.txt", "wt");
//    if (theList) fprintf(Outfile, theList);
//    fclose(Outfile);
    cp_free(theList);

    // NOTOK in 3rd param means just give common name and email addr

    DSGetCertList(NULL, "ADDRESSBOOK", NOTOK, &theList);
    MessageBox(NULL, theList?theList:"NULL", "ADDRESSBOOK CertStore Contents", MB_TASKMODAL);
//    Outfile = fopen("ADDRBOOK.txt", "wt");
//    if (theList) fprintf(Outfile, theList);
//    fclose(Outfile);
    cp_free(theList);

    DSGetCertList(NULL, "ROOT", OK, &theList);
    MessageBox(NULL, theList?theList:"NULL", "ROOT CertStore Contents (hit enter to proceed)", MB_TASKMODAL);
//    Outfile = fopen("ROOT.txt", "wt");
//    if (theList) fprintf(Outfile, theList);
//    fclose(Outfile);
    cp_free(theList);

    DSGetCertList(NULL, "CA", OK, &theList);
    MessageBox(NULL, theList?theList:"NULL", "CA CertStore Contents", MB_TASKMODAL);
//    Outfile = fopen("CA.txt", "wt");
//    if (theList) fprintf(Outfile, theList);
//    fclose(Outfile);
    cp_free(theList);

    DSGetCertList(NULL, "SPC", OK, &theList);
    MessageBox(NULL, theList?theList:"NULL", "SPC CertStore Contents", MB_TASKMODAL);
//    Outfile = fopen("SPC.txt", "wt");
//    if (theList) fprintf(Outfile, theList);
//    fclose(Outfile);
    cp_free(theList);

//    MessageBox(NULL, "cert store contents placed in text files", "Done", MB_TASKMODAL);
}


