// MetronomeDlg.cpp
#include "stdafx.h"
#include "Metronome.h"
#include "MetronomeDlg.h"

static HBITMAP hLeft;
static HBITMAP hRight;
static const int LORANGE = 60;
static const int HIRANGE = 280;
static CStatic* m_pPendulum;
static bool Ticktock = true;

CMetronomeDlg::CMetronomeDlg() : CDialog(IDD_METRONOME_DIALOG, 0)
{
	//{{AFX_DATA_INIT(CMetronomeDlg)
	m_nTempo = 120;
	//}}AFX_DATA_INIT
	m_bRunning = false;
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	hLeft = LoadBitmap(AfxGetApp()->m_hInstance, MAKEINTRESOURCE(IDB_LEFT));
	hRight = LoadBitmap(AfxGetApp()->m_hInstance, MAKEINTRESOURCE(IDB_RIGHT));
}
void CMetronomeDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMetronomeDlg)
	DDX_Control(pDX, IDC_PENDULUM, m_Pendulum);
	DDX_Control(pDX, IDC_TEMPO, m_Tempo);
	DDX_Control(pDX, IDC_START, m_StartStop);
	DDX_Control(pDX, IDC_SPIN1, m_TempoSpin);
	DDX_Text(pDX, IDC_TEMPO, m_nTempo);
	//}}AFX_DATA_MAP
}
BEGIN_MESSAGE_MAP(CMetronomeDlg, CDialog)
	//{{AFX_MSG_MAP(CMetronomeDlg)
	ON_BN_CLICKED(IDC_START, OnStart)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BOOL CMetronomeDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	SetIcon(m_hIcon, TRUE);				// Set big icon
	SetIcon(m_hIcon, FALSE);			// Set small icon
	CenterWindow(GetDesktopWindow());	// center to the hpc screen
	m_TempoSpin.SetRange(LORANGE,HIRANGE);
	return TRUE;
}
void CMetronomeDlg::OnStart() 
{
	if (m_bRunning)
		StopRunning();
	else
		StartRunning();
}
void CALLBACK TimerProc(HWND hwnd,UINT uMsg,UINT idEvent,DWORD dwTime) 
{
	sndPlaySound(TEXT("tick.wav"), SND_ASYNC);
	Ticktock ^= true;
	m_pPendulum->SetBitmap(Ticktock ? hLeft : hRight);
}
void CMetronomeDlg::StartRunning()
{
	m_pPendulum = &m_Pendulum;
	UpdateData(true);
	if (m_nTempo >= LORANGE && m_nTempo <= HIRANGE)	{
		m_bRunning = true;
		m_StartStop.SetWindowText(TEXT("Stop"));
		m_nTimer = ::SetTimer(0, 0, 60000 / m_nTempo, TimerProc);
	}
	else
		MessageBox(TEXT("Out of range"), 0, MB_ICONSTOP);
}
void CMetronomeDlg::StopRunning()
{
	m_bRunning = false;
	m_StartStop.SetWindowText(TEXT("Start"));
	::KillTimer(0, m_nTimer);
}
