/******************************************************************
* file: graphics3.c
*
* revision history:
*  02.29.96 / Rob / Created
******************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <iostream.h>
#include <math.h>

#include "graphics.h"

int TOP_LEFT_X = 200;
int TOP_LEFT_Y = 100;
int WIN_WIDTH = 553;
int WIN_HEIGHT = 553;
int SCALING_FACTOR = 553;
int SCALING_FACTOR_TOP = 0;
int SCALING_FACTOR_BOTTOM = 553;

//#define SIZE_X_AXIS (WIN_WIDTH-100)
//#define SIZE_Y_AXIS ((WIN_HEIGHT-100)/2)

//#define FIRST_AXIS_STARTX (50)
//#define FIRST_AXIS_STARTY ((WIN_HEIGHT-100)/2+25)
//#define SECOND_AXIS_STARTX (50)
//#define SECOND_AXIS_STARTY (WIN_HEIGHT-25)

Display       *myDisplay;
Window         myWindow;
int            myScreen;
unsigned long  foreground, background;
XSizeHints     hints;
GC             fgGc, bgGc;
const int      ColourCount = 216;
GC             colourGc[ColourCount];
XGCValues      myValues;

int
InitializeGraphics (int argc, char* argv[])
{
  myDisplay = XOpenDisplay (NULL);
  if (!myDisplay) {
    cerr << "XOpenDisplay failed" << endl;
    return 0;
  }

  myScreen = DefaultScreen (myDisplay);
  //background = WhitePixel (myDisplay,myScreen);
  //foreground = BlackPixel (myDisplay,myScreen);
  foreground = WhitePixel (myDisplay,myScreen);
  background = BlackPixel (myDisplay,myScreen);
  hints.x = TOP_LEFT_X;
  hints.y = TOP_LEFT_Y;
  hints.width = hints.min_width = hints.max_width = WIN_WIDTH;
  hints.height = hints.min_height = hints.max_height = WIN_HEIGHT;

  hints.flags = PPosition | PSize | PMinSize | PMaxSize;

  myWindow = XCreateSimpleWindow (myDisplay,DefaultRootWindow (myDisplay),
             hints.x, hints.y, hints.width, hints.height, 2, foreground,
             background);
  if (!myWindow) {
    cerr << "XCreateSimpleWindow failed" << endl;
    return 0;
  }

  XSetStandardProperties (myDisplay, myWindow, "Title", "IconTitle", None,
                          argv, argc, &hints);
  //XSelectInput (myDisplay, myWindow, ExposureMask | KeyPressMask);
  XSelectInput (myDisplay, myWindow, ButtonPressMask);
  XMapRaised (myDisplay, myWindow);

  // Create the PIXMAP and GRAPHICS CONTEXT
  //myGc->values.function = GXset;
  myValues.line_width = 5;
  fgGc = XCreateGC (myDisplay, myWindow, GCLineWidth, &myValues);
  bgGc = XCreateGC (myDisplay, myWindow, GCLineWidth, &myValues);
  //myGc = XCreateGC (myDisplay, myWindow, 0, 0);
  //bgGc = XCreateGC (myDisplay, myWindow, 0, 0);
  XSetForeground(myDisplay,fgGc,foreground);
  XSetForeground(myDisplay,bgGc,background);

  for(int i = 0; i < ColourCount; i++) {
    XColor xcolour;
    xcolour.red = (25 * (i%6) + 128) << 8;
    xcolour.green = (25 * ((i/6)%6) + 128) << 8;
    xcolour.blue = (25 * ((i/36)%6) + 128) << 8;
    xcolour.flags = DoRed|DoGreen|DoBlue;

    //cerr << xcolour.red/256 << ", " << xcolour.green/256 << ", "
	//<< xcolour.blue/256 << " = " << xcolour.pixel << "\t";
    unsigned long colour = XAllocColor(myDisplay,
		DefaultColormap(myDisplay,myScreen), &xcolour);
    myValues.foreground = xcolour.pixel;
    //cerr << xcolour.red/256 << ", " << xcolour.green/256 << ", "
	//<< xcolour.blue/256 << " = " << xcolour.pixel << endl;
    colourGc[i] = XCreateGC (myDisplay, myWindow, GCForeground, &myValues);
    XSetForeground (myDisplay, colourGc[i], xcolour.pixel);
  }

  return 1;
} /* InitializeGraphics */

int
ShutdownGraphics ()
{
  // Shut the system down
  XFreeGC (myDisplay, fgGc);
  XFreeGC (myDisplay, bgGc);
  for(int i = 0; i < ColourCount; i++) {
    XFreeGC (myDisplay, colourGc[i]);
  }
  XDestroyWindow (myDisplay, myWindow);
  XCloseDisplay (myDisplay);

  return 1;
} /* ShutdownGraphics */

int
ClearGraphicsScreen ()
{
  // Clear the screen
  XSetForeground (myDisplay, fgGc, background);
  XSetBackground (myDisplay, fgGc, foreground);
  XFillRectangle (myDisplay, myWindow, fgGc, 0, 0, hints.width, hints.height);

  // Reset the foreground and background colours
  XSetForeground (myDisplay, fgGc, foreground);
  XSetBackground (myDisplay, fgGc, background);

  if(SCALING_FACTOR_TOP) {
      SCALING_FACTOR = SCALING_FACTOR_TOP;
      //cerr << "Scaling_Factor set to " << SCALING_FACTOR << endl;
  }
  SCALING_FACTOR_TOP = 0;

  FlushGraphics();

  return 1;
} /* ClearGraphicsScreen */

XPoint clrpts[13];
void ClearPoint(int x, int y)
{
    x *= 7;	// we'll use 7x7 blocks for the screen;
    y *= 7;
    x += 4;	// x and y now to the centre of their block
    y += 4;

    clrpts[0].x = x;	clrpts[0].y = y;
    clrpts[1].x = x+1;	clrpts[1].y = y;
    clrpts[2].x = x+2;	clrpts[2].y = y;
    clrpts[3].x = x-1;	clrpts[3].y = y;
    clrpts[4].x = x-2;	clrpts[4].y = y;
    clrpts[5].x = x;	clrpts[5].y = y-1;
    clrpts[6].x = x;	clrpts[6].y = y-2;
    clrpts[7].x = x;	clrpts[7].y = y+1;
    clrpts[8].x = x;	clrpts[8].y = y+2;
    clrpts[9].x = x+1;	clrpts[9].y = y+1;
    clrpts[10].x = x+1;	clrpts[10].y = y-1;
    clrpts[11].x = x-1;	clrpts[11].y = y+1;
    clrpts[12].x = x-1;	clrpts[12].y = y-1;

    XDrawPoints(myDisplay,myWindow,bgGc,clrpts,13,CoordModeOrigin);
}

XPoint pts[13];
void DrawPoint(int x, int y, int currentColour)
{
    x *= 7;	// we'll use 7x7 blocks for the screen;
    y *= 7;
    x += 4;	// x and y now to the centre of their block
    y += 4;

    pts[0].x = x;	pts[0].y = y;
    pts[1].x = x+1;	pts[1].y = y;
    pts[2].x = x+2;	pts[2].y = y;
    pts[3].x = x-1;	pts[3].y = y;
    pts[4].x = x-2;	pts[4].y = y;
    pts[5].x = x;	pts[5].y = y-1;
    pts[6].x = x;	pts[6].y = y-2;
    pts[7].x = x;	pts[7].y = y+1;
    pts[8].x = x;	pts[8].y = y+2;
    pts[9].x = x+1;	pts[9].y = y+1;
    pts[10].x = x+1;	pts[10].y = y-1;
    pts[11].x = x-1;	pts[11].y = y+1;
    pts[12].x = x-1;	pts[12].y = y-1;
    XDrawPoints(myDisplay,myWindow,colourGc[currentColour%ColourCount],
		    pts,13,CoordModeOrigin);

    FlushGraphics();
}

XPoint blockpts[49];
void DrawBlock(int x, int y)
{
    x *= 7;
    y *= 7;

    for(int i = 0; i < 7; i++) {
	for(int j = 0; j < 7; j++) {
	    blockpts[7*i + j].x = x+i;
	    blockpts[7*i + j].y = y+j;
	}
    }
    XDrawPoints(myDisplay,myWindow,colourGc[0],blockpts,7*7,CoordModeOrigin);

    FlushGraphics();
}

void FlushGraphics()
{
    XFlush (myDisplay);
}
