#include <unistd.h>
#include <iostream.h>
#include <fstream.h>
#include <assert.h>
#include <math.h>

#include "graphics.h"

#define _PMAIN
#include "Ae.H"

Mutex X_mutex;

class RandomNumber
{
    private:
    unsigned int seed;
    static const unsigned int a;
    static const unsigned int q;
    static const unsigned int r;

    public:
    RandomNumber (unsigned int _seed = 1) :
	seed(_seed)
    {
	if(seed == 0)
	    seed = 1;
    }
    void setSeed (unsigned int _seed) {
	seed = _seed;
    }
    unsigned int sample () {
	return seed =  a * (seed % q) - r * (seed / q);
    }
};
const unsigned int RandomNumber::a (16807);
const unsigned int RandomNumber::q (127773);
const unsigned int RandomNumber::r (2836);

class Bugger : public C_we
{
    private:
	char const* const* const maze;
	bool const randomStart;
	int const rows;
	int const cols;

	class Point {
	    public: int r, c;
	};
	class Direction : public Point {
	};

    public:
	Bugger (int _r, int _c, char const* const* _m, bool _rand = TRUE) :
	    C_we(),
	    rows(_r),
	    cols(_c),
	    maze(_m),
	    randomStart(_rand)
	    {}
	~Bugger ()
	    {}

	/**
	 * do it.
	 */
	virtual void execute ();
	virtual We* clone () {
	    return new Bugger(*this);
	}
	virtual size_t size () {
	    return sizeof(*this);
	}
};

void Bugger::execute () {
    // pick a random starting point.
    Point p;
    Direction d;
    int colour = idInGroup() + 1;
    RandomNumber r(idInGroup()+1);

    if(randomStart) {
	p.r = r .sample() % rows;
	p.c = r .sample() % cols;
	while(maze[p.r][p.c] == 1) {
	    while(p.r < (cols-1) && p.r++ && maze[p.r][p.c] == 1)
		;
	    if(maze[p.r][p.c] == 1) {
		p.r = r .sample() % rows;
		p.c = r .sample() % cols;
	    }
	}
    } else {
	p.r = p.c = 0;
	while(maze[p.r][p.c] == 1) {
	    p.c++;
	    if(p.c == rows) {
		p.c = 0;
		p.r++;
	    }
	}
    }
    {
	Synchronize _with(X_mutex);
	DrawPoint(p.c, p.r, colour);
    }
    d.r = 1;
    d.c = 0;

    unsigned moves = 0;
    while( p.r > 0 && p.c > 0 && p.r < rows-1 && p.c < cols-1 ) {
	// 66% chance of taking a turn for no reason
	//
	unsigned rand = r .sample() % 3;
	switch(rand) {
	    case 0:
		if(d.c != 0) { // try looking left
		    if(maze[p.r + 1][p.c] == 0) {
			d.r = 1; d.c = 0;
		    }
		} else {  // try looking up
		    if(maze[p.r][p.c + 1] == 0) {
			d.r = 0; d.c = 1;
		    }
		}
		break;
	    case 1:
		if(d.c != 0) { // try looking left
		    if(maze[p.r - 1][p.c] == 0) {
			d.r = -1; d.c = 0;
		    }
		} else { // try looking down
		    if(maze[p.r][p.c - 1] == 0) {
			d.r = 0; d.c = -1;
		    }
		}
		break;
	}

	if(maze[p.r + d.r][p.c + d.c] == 1) {
	    if(d.r == 1) {
		while(maze[p.r + d.r][p.c + d.c] == 1) {
		    rand = r .sample() % 5;
		    switch(rand) {
			case 0: case 1: d.c =  1; d.r =  0; break;
			case 2: case 3: d.c = -1; d.r =  0; break;
			case 4:         d.c =  0; d.r = -1; break;
		    }
		}
	    } else if(d.r == -1) {
		while(maze[p.r + d.r][p.c + d.c] == 1) {
		    rand = r .sample() % 5;
		    switch(rand) {
			case 0: case 1: d.c =  1; d.r =  0; break;
			case 2: case 3: d.c = -1; d.r =  0; break;
			case 4:         d.c =  0; d.r =  1; break;
		    }
		}
	    } else if(d.c == 1) {
		while(maze[p.r + d.r][p.c + d.c] == 1) {
		    rand = r .sample() % 5;
		    switch(rand) {
			case 0:         d.c = -1; d.r =  0; break;
			case 1: case 2: d.c =  0; d.r =  1; break;
			case 3: case 4: d.c =  0; d.r = -1; break;
		    }
		}
	    } else if(d.c == -1) {
		while(maze[p.r + d.r][p.c + d.c] == 1) {
		    rand = r .sample() % 5;
		    switch(rand) {
			case 0:         d.c =  1; d.r =  0; break;
			case 1: case 2: d.c =  0; d.r =  1; break;
			case 3: case 4: d.c =  0; d.r = -1; break;
		    }
		}
	    }
	}

	timeval timeout;	timeout.tv_sec = 0; timeout.tv_usec = 1000;
	select(idInGroup()+1, 0, 0, 0, &timeout);

	Synchronize _with(X_mutex);
	ClearPoint(p.c, p.r);
	p.r += d.r;
	p.c += d.c;
	DrawPoint(p.c, p.r, colour);

	moves++;
    }
    MSG(idInGroup(), "moves taken =", moves);
}

int pmain (int argc, char** argv) {
    int rows, cols;
    char **maze;
    int n;
    bool rs = FALSE;

    //
    // get the arguements
    if(argc > 3) {
	n = atoi(argv[1]);
	MSG("n",n);
	assert(n > 0);
	if(argv[2][0] == 't')
	    rs = TRUE;
    } else {
	cerr << "usage: " << argv[0] << " n {t|f} mazefile" << endl;
	cerr << " where n is the number of bugs\n";
	cerr << " and t or f indicate a random starting position desire\n";
	return 1;
    }

    //
    // set up the graphics
    InitializeGraphics(argc, argv);
    ClearGraphicsScreen();
    cerr << "Graphics initialized" << endl;

    ifstream infile(argv[3]);
    assert(infile);
    infile >> rows >> cols;  assert(rows > 0);  assert(cols > 0);
    maze = new char*[rows];		assert(maze);
    char endline;
    infile.get(endline);	assert(endline == '\n');
    for(int i = 0; i < rows; i++) {
	maze[i] = new char[cols];	assert(maze[i]);
	for(int j = 0; j < cols; j++) {
	    char in;
	    infile.get(in);	assert(in == 'X' || in == ' ');
	    if(in == 'X') {
		maze[i][j] = 1;
		DrawBlock(j, i);
	    }
	    else
		maze[i][j] = 0;
	}
	infile.get(endline);	assert(endline == '\n');
    }

    Bugger bugger(rows, cols, maze, rs);

    {
	C_AeHandle h = ( n*bugger );
    }

    ShutdownGraphics();

    //return 0;
}
