/******************************************************************
* file: graphics3.c
*
* revision history:
*  02.29.96 / Rob / Created
******************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <iostream.h>
#include <math.h>

#include "graphics.h"

int TOP_LEFT_X = 200;
int TOP_LEFT_Y = 100;
int WIN_WIDTH = 800;
int WIN_HEIGHT = 800;
int SCALING_FACTOR = 800;
int SCALING_FACTOR_TOP = 0;
int SCALING_FACTOR_BOTTOM = 800;

//#define SIZE_X_AXIS (WIN_WIDTH-100)
//#define SIZE_Y_AXIS ((WIN_HEIGHT-100)/2)

//#define FIRST_AXIS_STARTX (50)
//#define FIRST_AXIS_STARTY ((WIN_HEIGHT-100)/2+25)
//#define SECOND_AXIS_STARTX (50)
//#define SECOND_AXIS_STARTY (WIN_HEIGHT-25)

Display       *myDisplay;
Window         myWindow;
int            myScreen;
unsigned long  foreground, background;
XSizeHints     hints;
GC             myGc, bgGc;
const int      ColourCount = 216;
GC             colourGc[ColourCount];
Pixmap         myPixMap;
XGCValues      myValues;

int
InitializeGraphics (int argc, char* argv[])
{
  myDisplay = XOpenDisplay (NULL);
  if (!myDisplay) {
    cerr << "XOpenDisplay failed" << endl;
    return 0;
  }

  myScreen = DefaultScreen (myDisplay);
  //background = WhitePixel (myDisplay,myScreen);
  //foreground = BlackPixel (myDisplay,myScreen);
  foreground = WhitePixel (myDisplay,myScreen);
  background = BlackPixel (myDisplay,myScreen);
  hints.x = TOP_LEFT_X;
  hints.y = TOP_LEFT_Y;
  hints.width = hints.min_width = hints.max_width = WIN_WIDTH;
  hints.height = hints.min_height = hints.max_height = WIN_HEIGHT;

  hints.flags = PPosition | PSize | PMinSize | PMaxSize;

  myWindow = XCreateSimpleWindow (myDisplay,DefaultRootWindow (myDisplay),
             hints.x, hints.y, hints.width, hints.height, 2, foreground,
             background);
  if (!myWindow) {
    cerr << "XCreateSimpleWindow failed" << endl;
    return 0;
  }

  XSetStandardProperties (myDisplay, myWindow, "Title", "IconTitle", None,
                          argv, argc, &hints);
  //XSelectInput (myDisplay, myWindow, ExposureMask | KeyPressMask);
  XSelectInput (myDisplay, myWindow, ButtonPressMask);
  XMapRaised (myDisplay, myWindow);

  // Create the PIXMAP and GRAPHICS CONTEXT
  //myPixMap = XCreatePixmap (myDisplay, myWindow, hints.width, hints.height,
             //XDefaultDepth (myDisplay, myScreen));
  //myGc = XCreateGC (myDisplay, myPixMap, 0, 0);
  //myGc->values.function = GXset;
  myValues.line_width = 5;
  myGc = XCreateGC (myDisplay, myWindow, GCLineWidth, &myValues);
  bgGc = XCreateGC (myDisplay, myWindow, GCLineWidth, &myValues);
  //myGc = XCreateGC (myDisplay, myWindow, 0, 0);
  //bgGc = XCreateGC (myDisplay, myWindow, 0, 0);
  XSetForeground(myDisplay,myGc,foreground);
  XSetForeground(myDisplay,bgGc,background);

  for(int i = 0; i < ColourCount; i++) {
    XColor xcolour;
    xcolour.red = (25 * (i%6) + 128) << 8;
    xcolour.green = (25 * ((i/6)%6) + 128) << 8;
    xcolour.blue = (25 * ((i/36)%6) + 128) << 8;
    xcolour.flags = DoRed|DoGreen|DoBlue;

    //cerr << xcolour.red/256 << ", " << xcolour.green/256 << ", "
	//<< xcolour.blue/256 << " = " << xcolour.pixel << "\t";
    unsigned long colour = XAllocColor(myDisplay,
		DefaultColormap(myDisplay,myScreen), &xcolour);
    myValues.foreground = xcolour.pixel;
    //cerr << xcolour.red/256 << ", " << xcolour.green/256 << ", "
	//<< xcolour.blue/256 << " = " << xcolour.pixel << endl;
    colourGc[i] = XCreateGC (myDisplay, myWindow, GCForeground, &myValues);
    XSetForeground (myDisplay, colourGc[i], xcolour.pixel);
  }

  return 1;
} /* InitializeGraphics */

int
ShutdownGraphics ()
{
  // Shut the system down
  //XFreePixmap (myDisplay, myPixMap);
  XFreeGC (myDisplay, myGc);
  XDestroyWindow (myDisplay, myWindow);
  XCloseDisplay (myDisplay);

  return 1;
} /* ShutdownGraphics */

int
ClearGraphicsScreen ()
{
  // Clear the screen
  XSetForeground (myDisplay, myGc, background);
  XSetBackground (myDisplay, myGc, foreground);
  //XFillRectangle (myDisplay, myPixMap, myGc, 0, 0, hints.width, hints.height);
  XFillRectangle (myDisplay, myWindow, myGc, 0, 0, hints.width, hints.height);

  // Reset the foreground and background colours
  XSetForeground (myDisplay, myGc, foreground);
  XSetBackground (myDisplay, myGc, background);

  if(SCALING_FACTOR_TOP) {
      SCALING_FACTOR = SCALING_FACTOR_TOP;
      //cerr << "Scaling_Factor set to " << SCALING_FACTOR << endl;
  }
  SCALING_FACTOR_TOP = 0;

  //XCopyArea (myDisplay, myPixMap, myWindow, myGc, 0, 0, hints.width,
		 //hints.height, 0, 0);
  FlushGraphics();

  return 1;
} /* ClearGraphicsScreen */

XPoint clrpts[13];
void ClearPoint(double x, double y)
{
    int xpix = WIN_HEIGHT/2 + (int)(x*WIN_HEIGHT)/SCALING_FACTOR;
    int ypix = WIN_WIDTH - (int)(y*WIN_WIDTH)/SCALING_FACTOR;
    clrpts[0].x = xpix;		clrpts[0].y = ypix;
    clrpts[1].x = xpix+1;	clrpts[1].y = ypix;
    clrpts[2].x = xpix+2;	clrpts[2].y = ypix;
    clrpts[3].x = xpix-1;	clrpts[3].y = ypix;
    clrpts[4].x = xpix-2;	clrpts[4].y = ypix;
    clrpts[5].x = xpix;		clrpts[5].y = ypix-1;
    clrpts[6].x = xpix;		clrpts[6].y = ypix-2;
    clrpts[7].x = xpix;		clrpts[7].y = ypix+1;
    clrpts[8].x = xpix;		clrpts[8].y = ypix+2;
    clrpts[9].x = xpix+1;	clrpts[9].y = ypix+1;
    clrpts[10].x = xpix+1;	clrpts[10].y = ypix-1;
    clrpts[11].x = xpix-1;	clrpts[11].y = ypix+1;
    clrpts[12].x = xpix-1;	clrpts[12].y = ypix-1;

    XDrawPoints(myDisplay,myWindow,bgGc,clrpts,13,CoordModeOrigin);

    FlushGraphics();
}

XPoint pts[13];
void DrawPoint(double x, double y, int currentColour)
{
    // we want x*WIN_HEIGHT/SCALING_FACTOR <= WIN_HEIGHT/2
    int desired_scale = (int)(fabs(x)+1)*2;
    if(desired_scale > SCALING_FACTOR_TOP)
	SCALING_FACTOR_TOP = desired_scale;
    desired_scale = (int)(fabs(y)+1)*2;
    if(desired_scale > SCALING_FACTOR_TOP)
	SCALING_FACTOR_TOP = desired_scale;
    int xpix = WIN_HEIGHT/2 + (int)(x*WIN_HEIGHT)/SCALING_FACTOR;
    int ypix = WIN_WIDTH - (int)(y*WIN_WIDTH)/SCALING_FACTOR;
    pts[0].x = xpix;	pts[0].y = ypix;
    pts[1].x = xpix+1;	pts[1].y = ypix;
    pts[2].x = xpix+2;	pts[2].y = ypix;
    pts[3].x = xpix-1;	pts[3].y = ypix;
    pts[4].x = xpix-2;	pts[4].y = ypix;
    pts[5].x = xpix;	pts[5].y = ypix-1;
    pts[6].x = xpix;	pts[6].y = ypix-2;
    pts[7].x = xpix;	pts[7].y = ypix+1;
    pts[8].x = xpix;	pts[8].y = ypix+2;
    pts[9].x = xpix+1;	pts[9].y = ypix+1;
    pts[10].x = xpix+1;	pts[10].y = ypix-1;
    pts[11].x = xpix-1;	pts[11].y = ypix+1;
    pts[12].x = xpix-1;	pts[12].y = ypix-1;
    //XDrawPoint(myDisplay,myPixMap,myGc,xpix,ypix);
    //XDrawPoints(myDisplay,myWindow,myGc,pts,13,CoordModeOrigin);
    XDrawPoints(myDisplay,myWindow,colourGc[currentColour%ColourCount],
		    pts,13,CoordModeOrigin);

    FlushGraphics();
}

void FlushGraphics()
{
    XFlush (myDisplay);
}
