#include <iostream.h>
#include <math.h>

#include "kernel.h"

Kernel::Kernel () :
    x(0), y(0),
    vx(0), vy(0),
    m(1)
    {}

/*
Kernel::Kernel (double x, double y, double m) :
    x(_x), y(_y),
    m(_m)
    {}
*/

Kernel::~Kernel ()
    {}

void Kernel::push (double fx, double fy, double dt) {
    vx += fx*dt/m;
    vy += fy*dt/m;
}

void Kernel::move (double dt) {
    x += dt*vx;
    y += dt*vy;

    if(y < 0) y = 0;
    if(x > 380) x = 380;
    if(x < -380) x = -380;

    vy -= 9.8*dt;
}

void Kernel::shove (double dx, double dy) {
    x += dx;
    y += dy;
}
    

ostream& Kernel::put (ostream& s) const {
    s << "(" << x << "," << y << ")" << " moving " << vx << "," << vy;
    return s;
}

istream& Kernel::read (istream& s) {
    s >> m;
    double v, theta; s >> v >> theta;
    vx = v * cos(theta);
    vy = v * sin(theta);
    s >> x >> y;
    return s;
}
