#ifndef Kernel_h__
#define Kernel_h__

#include <iostream.h>
#include <math.h>

class Kernel {
    private:
    double x, y;	// m
    double vx, vy;	// m/s
    double m;		// kg

    public:
    Kernel ();
    ~Kernel ();

    double getX () const { return x; }
    double getY () const { return y; }
    double getM () const { return m; }
    double getV () const { return sqrt(vx*vx + vy*vy); }

    void move (double);
    void push (double, double, double);
    void shove (double, double);

    ostream& put (ostream&) const;
    istream& read (istream&);
};

inline ostream& operator << (ostream& s, Kernel const& b)
    { return b .put(s); }
inline istream& operator >> (istream& s, Kernel & b)
    { return b .read(s); }
    
#endif
