#include <iostream.h>
#include <fstream.h>
#include <assert.h>
#include <math.h>

#include "kernel.h"
#include "graphics.h"

#define _PMAIN
#include "Ae.H"

// some simulation constants;
//double dt = 1e-5;
//const double G = 6.67e-4;
//int seconds = 10;

Mutex X_mutex;

class Taunt {
    public:
	double myx, myy;
};
    
class BodyGuard : public I_we<Taunt>
{
    private:
	const double dt;

	Kernel kernel;

    public:
	BodyGuard (double _dt) :
	    I_we<Taunt>(),
	    dt(_dt)
	    {}
	~BodyGuard ()
	    {}

	/**
	 * do it.
	 */
	virtual void execute ();
	virtual We* clone () {
	    return new BodyGuard(*this);
	}
	virtual size_t size () {
	    return sizeof(*this);
	}
};

void BodyGuard::execute () {
    Taunt bastard;
    while( pin >> bastard ) {
	double dx = bastard.myx - kernel.getX();
	double dy = bastard.myy - kernel.getY();

	double fx = dx * kernel.getM();
	if(fx > 200) fx = 200; else if(fx < -200) fx = -200;
	double fy = dy * kernel.getM() * 1.7;

	kernel.push(fx, fy, dt);
	{
	    Synchronize _with(X_mutex);
	    ClearPoint(kernel.getX(), kernel.getY());
	    kernel.move(dt);
	    DrawPoint(kernel.getX(), kernel.getY(), idInGroup()+1);
	}

	while(kernel.getY() <= 0) {
	    kernel.shove(0,0.000001);
	}

	while(kernel.getY() > 0) {
	    timeval timeout;	timeout.tv_sec = 0; timeout.tv_usec = 10000;
	    select(idInGroup()+1, 0, 0, 0, &timeout);

	    Synchronize _with(X_mutex);
	    ClearPoint(kernel.getX(), kernel.getY());
	    kernel.move(dt);
	    DrawPoint(kernel.getX(), kernel.getY(), idInGroup()+1);
	}
    }
}

//Mutex X_mutex;
//void BodyGuard::draw () {
//    //Synchronize _with(X_mutex);
//    for(int a = myFirst; a <= myLast; a++) {
//	DrawPoint(body[a].getX(), body[a].getY());
//    }
//}

class Headly : public O_we<Taunt>
{
    private:
	const double x_max;
	const double vx;
	const double y;
	const double duration;
	const double dt;
	const int r;
	double elapsed;
    public:
	Headly (double _duration, double _dt, int _r) :
	    O_we<Taunt>(),
	    duration(_duration),
	    dt(_dt),
	    r(_r),
	    x_max(300),
	    vx(10),
	    y(700),
	    elapsed(0)
	    {}
	
	virtual void execute ();
	virtual We* clone () {
	    return new Headly(*this);
	}
	virtual size_t size () {
	    return sizeof(*this);
	}
};

void Headly::execute () {
    int i = 0;
    int x = 0;
    int dx = 1;

    int old_x, old_y;		old_x = x; old_y = y;

    FlushGraphics();
    ClearGraphicsScreen();

    while(elapsed < duration) {
	if(i % r == 0) {
	    Taunt taunt;	taunt.myx = x; taunt.myy = y;
	    pout << taunt;
	}

	if(i % 2 == 0) {
	    Synchronize _with(X_mutex);
	    ClearPoint(old_x,old_y);
	    ClearPoint(old_x+5,old_y);
	    ClearPoint(old_x-5,old_y);
	    ClearPoint(old_x,old_y+5);
	    ClearPoint(old_x,old_y-5);
	    DrawPoint(x,y,0);
	    DrawPoint(x+5,y,0);
	    DrawPoint(x-5,y,0);
	    DrawPoint(x,y+5,0);
	    DrawPoint(x,y-5,0);
	    old_x = x; old_y = y;
	}

	if(dx > 0) {
	    x += vx*dt;
	    if(x > x_max) dx = -1;
	} else {
	    x -= vx*dt;
	    if(x < -x_max) dx = 1;
	}

	timeval timeout;	timeout.tv_sec = 0; timeout.tv_usec = 10000;
	select(0, 0, 0, 0, &timeout);

	elapsed += dt;
	i++;
    }
}

int pmain (int argc, char** argv) {
    int n, r;
    double dt, dur;

    //
    // get the arguements
    if(argc > 4) {
	n = atoi(argv[1]);
	MSG("n",n);
	assert(n > 0);
	r = atoi(argv[2]);
	MSG("r",r);
	assert(r > 0);
	dt = atof(argv[3]);
	MSG("dt",dt);
	assert(dt > 0);
	dur = atof(argv[4]);
	MSG("dur",dur);
	assert(dur > 0);
    } else {
	cerr << "usage: " << argv[0] << " n r dt dur" << endl;
	cerr << " where n is the number of serves and r is the period\n"
	     << " between hits, dt is the step size (float) and dur is\n"
	     << " the duration (float)\n"
	     << " A good run is 50 5 .1 100\n";
	return 1;
    }

    //
    // set up the graphics
    InitializeGraphics(argc, argv);
    ClearGraphicsScreen();

    Headly headly(dur, dt, r);
    BodyGuard bodyguard(dt);

    {
    C_AeHandle h = ( headly|(n*bodyguard) );
    }

    ShutdownGraphics();

    return 0;
}
