#include <iostream.h>
#include <math.h>

#include "bug.h"

Bug::Bug (double _v) :
    x(0), y(0),
    vx(_v), vy(0),
    v(_v)
    {}

Bug::~Bug ()
    {}

void Bug::headTowards (double _x, double _y) {
    const double dx = _x - x;
    const double dy = _y - y;
    const double r = sqrt(dx*dx + dy*dy);

    vx = dx * v/r;
    vy = dy * v/r;
}

void Bug::move (double dt) {
    x += dt*vx;
    y += dt*vy;

    if(y > 380) y = 380;
    if(y < -380) y = -380;
    if(x > 380) x = 380;
    if(x < -380) x = -380;
}

ostream& Bug::put (ostream& s) const {
    s << "(" << x << "," << y << ")" << " moving " << vx << "," << vy;
    return s;
}
