#ifndef Bug_h__
#define Bug_h__

#include <iostream.h>
#include <math.h>

class Bug {
    protected:
    double x, y;	// m
    double vx, vy;	// m/s
    const double v;

    public:
    Bug (double);
    virtual ~Bug ();

    double getX () const { return x; }
    double getY () const { return y; }
    double getV () const { return sqrt(vx*vx + vy*vy); }

    void move (double);			// move for dt
    void headTowards (double, double);		// new v

    ostream& put (ostream&) const;
};

inline ostream& operator << (ostream& s, Bug const& b)
    { return b .put(s); }
    
#endif
