#include <unistd.h>
#include <iostream.h>
#include <fstream.h>
#include <assert.h>
#include <math.h>

#include "bug.h"
#include "graphics.h"

#define _PMAIN
#include "Ae.H"

Mutex X_mutex;

class Taunt {
    public:
	double myx, myy;
};
    
class Bugger : public I_we<Taunt>
{
    private:
	const double dt;

	Bug bug;

    public:
	Bugger (double _dt, double _v) :
	    I_we<Taunt>(),
	    dt(_dt),
	    bug(_v)
	    {}
	~Bugger ()
	    {}

	/**
	 * do it.
	 */
	virtual void execute ();
	virtual We* clone () {
	    return new Bugger(*this);
	}
	virtual size_t size () {
	    return sizeof(*this);
	}
};

void Bugger::execute () {
    Taunt bastard;
    while( pin ) {
	if(pin .attempt(bastard)) {
	    bug.headTowards(bastard.myx, bastard.myy);
	    //MSG(idInGroup(), "heading for", bastard.myx, bastard.myy);
	}

	timeval timeout;	timeout.tv_sec = 0; timeout.tv_usec = 10000;
	select(idInGroup()+1, 0, 0, 0, &timeout);

	Synchronize _with(X_mutex);
	ClearPoint(bug.getX(), bug.getY());
	bug.move(dt);
	DrawPoint(bug.getX(), bug.getY(), idInGroup()+1);
    }
    //MSG("Bugger done", idInGroup());
}

class Headly : public Bug, public O_we<Taunt>
{
    private:
	const double duration;
	const double dt;
	const int r;
	const int b;
	double elapsed;

    public:
	Headly (double _duration, double _dt, int _r, int _b, int _v) :
	    O_we<Taunt>(),
	    Bug(_v),
	    duration(_duration),
	    dt(_dt),
	    r(_r),
	    b(_b),
	    elapsed(0)
	    {}
	
	virtual void execute ();
	virtual We* clone () {
	    return new Headly(*this);
	}
	virtual size_t size () {
	    return sizeof(*this);
	}
};

void Headly::execute () {
    int i = 1;
    int dx = 1;

    int old_x, old_y;		old_x = x; old_y = y;

    FlushGraphics();
    ClearGraphicsScreen();

    while(elapsed < duration) {
	if((i % r) == 0) {
	    Taunt taunt;	taunt.myx = x; taunt.myy = y;
	    for(int j = 0; j < b; j++)
		pout << taunt;
	}

	if(i % 2 == 0) {
	    Synchronize _with(X_mutex);
	    ClearPoint(old_x,old_y);
	    DrawPoint(x,y,215);
	    old_x = x; old_y = y;
	}

	const double x_max = 380;
	const double y_max = 380;
	x += vx*dt;
	if(x > x_max) x = x_max;
	else if(x < -x_max) x = -x_max;

	y += vy*dt;
	if(y > y_max) y = y_max;
	else if(y < -y_max) y = -y_max;

	timeval timeout;	timeout.tv_sec = 0; timeout.tv_usec = 10000;
	select(0, 0, 0, 0, &timeout);

	// rand_max*v/x = rand_max*1 when v = 400.
	// rand_max*v/x = rand_max*1/4 when v = 100.
	// x = 400  (Gosh, I'm tired)
	if(rand() < RAND_MAX*v/800) {
	    double theta = 2. * M_PI * rand()/RAND_MAX;
	    vx = v * cos(theta);
	    vy = v * sin(theta);
	}

	elapsed += dt;
	i++;
    }
}

int pmain (int argc, char** argv) {
    int n, r, b;
    double dt, dur, v;

    //
    // get the arguements
    if(argc > 4) {
	n = atoi(argv[1]);
	MSG("n",n);
	assert(n > 0);
	r = atoi(argv[2]);
	MSG("r",r);
	assert(r > 0);
	b = atoi(argv[3]);
	MSG("b",b);
	assert(b > 0);
	dt = atof(argv[4]);
	MSG("dt",dt);
	assert(dt > 0);
	dur = atof(argv[5]);
	MSG("dur",dur);
	assert(dur > 0);
	v = atof(argv[6]);
	MSG("v",v);
	assert(v > 0);
    } else {
	cerr << "usage: " << argv[0] << " n r b dt dur v" << endl;
	cerr << " where n is the number of bugs and r is the period\n"
	     << " between message sends, b is the number of messages to send\n"
	     << " at a time, dt is the step size (float), dur is\n"
	     << " the duration (float), and v is the velocity of the bees\n"
	     << " a good run is 100 1 3 .1 300 30\n";
	return 1;
    }

    //
    // set up the graphics
    InitializeGraphics(argc, argv);
    ClearGraphicsScreen();

    Headly headly(dur, dt, r, b, v);
    Bugger bugger(dt, v*1.2);

    {
    C_AeHandle h = ( headly|(n*bugger) );
    }

    ShutdownGraphics();

    return 0;
}
