// ------------------------------------------------------------
// Active Expressions
//
// A Framework for Pattern-Based Concurrency
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation, version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

#ifndef AE_PASS
#define AE_PASS

#define _BSD 43

// Std Libraries
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <iostream.h>
#include <fstream.h>
#include <string.h>

#if AIX
# include <strings.h>
#endif

#include <assert.h>

// Thread packages
#if PTHREADS
# include <pthread.h>
#elif UITHREADS
# include <thread.h>
#endif

// System Libraries 
#include <errno.h>
#include <signal.h>
#include <sys/types.h>


// Network libraries
#include <netdb.h>
#include <sys/select.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>

// STL 
#include <vector.h>

//
// Defaults
#include "defaults.H"

// Type definitions
#include "types.H"

// Local limits
#include "limits.H"

// Forward declarations
#include "declarations.H"
#include "forward.H"
#include "helpers.H"
#include "macros.H"

//
// Helpers and common abstractions
//

#include "autoptr.H"
#include "fail.H"
#include "sizeable.H"
#include "proc_t.H"
#include "thread_t.H"
#include "singleton.H"
#include "exception_s.H"
#include "debug_s.H"
#include "mutex_s.H"
#include "debugstate_s.H"
#include "synchronize.H"
#include "recursivesync.H"
#include "io.H"
#include "exception.H"
#include "mutex.H"
#include "msg.H"
#include "cond.H"
#include "semaphore.H"
#include "wait.H"
#include "mtvector.H"
#include "singmanage.H"
#include "debugstate.H"
#include "debug.H"
#include "exsafethreadep_s.H"
#include "threadgroup_t.H"
#include "thread_s.H"
#include "mtautoptr.H"
#include "terminate.H"

//
// Interface Definition for Queue
//

#include "pqueue_s.H"

//
// Run-time system
//

#if DISTMEM
# include "channel.H"
# include "sautoptr.H"
# include "channeltokens.H"
# include "lockedchannel.H"
#endif

#include "stream.H"

#if DISTMEM
# include "pickle.H"
# include "depickle.H"
# include "streamop.H"
# include "lockedchannelop.H"
# include "handler.H"
# include "threadedhandler.H"
# include "command.H"
# include "commandhandler.H"
# include "commreply.H"
# include "pqueuechannel.H"
# include "terminateserver.H"
# include "serverstatus.H"
# include "server.H"
# include "socket.H"
# include "tcpserver.H"
# include "procmap.H"
# include "procbind.H"
#endif

// Queues
#include "pqueue_i.H"
#include "broadcastqueue.H"
#include "pqueuehandle.H"

#if DISTMEM
# include "dequehandler.H"
# include "broadcasthandler.H"
# include "createremotequeue.H"
#endif

#include "pqueueloc.H"
#include "pqueueinstantiator.H"

#if DISTMEM
# include "enque.H"
# include "deque.H"
# include "eoq.H"
# include "pqueueremote.H"
# include "localchannel.H"
#endif

// Facade for RTS
#if DISTMEM
# include "initcommands_s.H"
# include "stopcommands.H"
# include "commengine.H"
# include "initcommands.H"
#endif

// DPtreads
#include "createthreadinfo.H"
#include "exsafethreadep.H"

#if DISTMEM
# include "threadremotecreate.H"
# include "joinhandler.H"
# include "joinmanager.H"
# include "threadremotejoin.H"
#endif

#include "thread.H"

//
// Distributed Shared Memory
//

#include "sharedlock.H"
#include "shared.H"


#if DISTMEM
// Startup RTS
# include "startup.H"
# include "initservers.H"
# include "deamon.H"
# include "rts.H"
#endif

// MT Exception-safe main replacement
#ifdef _PMAIN
# include "pmain.H"
#endif

// Data-Flow Expression
#include "dfenode.H"
#include "dfeopnode.H"
#include "pipe.H"
#include "rep.H"
#include "broadcast.H"
#include "concexec.H"
#include "dfehandle.H"
#include "instatiatemutex.H"
#include "aehandle.H"
#include "bang.H"
#include "we_s.H"
#include "weboot.H"
#include "wefactory.H"
#include "we.H"
#include "acsupportmethods.H"
#include "operations.H"
#include "reduce.H"

#if SHMEM
# include "cycle.H"
#endif

#endif
