// ============================================================
//
// NAME:             autoptr.H
// AUTHOR:           Mauricio De Simone
// EMAIL:            mdesimon@interlog.com
// DESCRIPTION:
//  Automatic pointer to be used for proper resource
//  reclaim in the prescence of exceptions
//
//  To be used like:
//    autoptr<T> var = new T;
//
//  Note: var should be treated as a pointer to type T!
// 
// ------------------------------------------------------------
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ============================================================

template<class T>
class autoptr 
{
public:

  //
  // Constructors and Destructors
  //
  
  autoptr(T* data) :
    _data(data) {
      assert(_data != NULL);
  }

  ~autoptr() {
    assert(_data != NULL);
    delete _data; _data = NULL;
  }

  //
  // Pointer Access Methods
  //
  
  T* operator->() {
#if DEBUG
    assert(_data != NULL);
#endif
    return _data;
  }

  T& operator*() {
#if DEBUG
    assert(_data != NULL);
#endif
    return *_data;
  }

private:
  T* _data;
};

