// ------------------------------------------------------------
// 
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

//
// Base BroadCast
//
template <class T_MID>
class BroadCast :
  public DfeOpnode
{
public:
  //
  // Instantiate
  void instantiate(DfeNode& parent, AeHandle& handle)
  {
#if DISTMEM
    if (_right->where() == ProcBinding::whereever) {
      _right->where(ProcBinding::instance()->where());
    }
#endif
    
    // Create new queue
    // Careful with this code!
    // Also inform queue of it's cardinality
    PqueueInstantiator<T_MID> loc(left()->num(), right()->num()
#if DISTMEM
      ,(_right->where())
#endif
     , TRUE);

    // Set desendants' queues
    left()->sink(loc);
    right()->source(loc);

    // Pass down the inheritance tree
    DfeNode::instantiate(parent, handle);
  }

  //
  // Number in the replication
  virtual int num() {
#if DEBUG_EE
    DEBUGOBJ dummy("BROADCASTQUEUE", this, "Getting Num");
#endif

    return right()->num();
  }

  virtual void num(int /* num */) {
    throw ExNum(__FILE__, __LINE__);
  }
  

#if DISTMEM
  //
  // Where
  virtual proc_t where() {
    return _left->where();
  }
  virtual void where(proc_t where) {
    _left->where(where);
  }
#endif
};

//
// Closed BroadCast
//
template <class T_MID>
class C_BroadCast :
  public BroadCast<T_MID>,
  public C_DfeOpnode
{};

//
// Input Pipe
//
template <class T_IN, class T_MID>
class I_BroadCast :
  public BroadCast<T_MID>,
  public I_DfeOpnode<T_IN>
{
public:
  // Set source
  // Give source to left element
  virtual void source(PqueueLocator& loc) {
    left()->source(loc); 
  }
};

//
// Output pipe
//
template <class T_MID, class T_OUT>
class O_BroadCast :
  public BroadCast<T_MID>,
  public O_DfeOpnode<T_OUT>
{
public:
  // Set sink
  // Give sink to right element
  void sink(PqueueLocator& loc) {
    right()->sink(loc); 
  }
};

//
// IO Pipe
//
template <class T_IN, class T_MID, class T_OUT>
class IO_BroadCast :
  public BroadCast<T_MID>,
  public IO_DfeOpnode<T_IN, T_OUT>
{
public:
  // Set source
  // Give source to left element
  void source(PqueueLocator& loc) {
    left()->source(loc); 
  }
  // Set sink
  // Give sink to right element
  void sink(PqueueLocator& loc) {
    right()->sink(loc); 
  }
};


// --------------------------------------------------
// Pipe operator
// --------------------------------------------------

//
// Unify O | I
//
template <class T>
C_BroadCast<T>&
operator || (const O_DfeNode<T>& lhs, const I_Rep<T>& rhs)
{
#if DEBUG_EE
  DEBUGOBJ dummy("OPERATORS", NULL, "|| (O, I)");
#endif

  C_BroadCast<T>* node = new C_BroadCast<T>;
  node->left(&lhs);
  node->right(&rhs);
  return *node;
}

//
// Unify IO | I
//
template <class T0, class T1>
I_DfeNode<T0>&
operator || (const IO_DfeNode<T0, T1>& lhs, I_Rep<T1>& rhs)
{
#if DEBUG_EE
  DEBUGOBJ dummy("OPERATORS", NULL, "|| (IO, I)");
#endif
  
  I_DfeNode<T0>* node = new I_BroadCast<T0, T1>;
  node->left(&lhs);
  node->right(&rhs);

  return *node;
}

//
// Unify O | IO
//
template <class T0, class T1>
O_DfeNode<T1>&
operator || (const O_DfeNode<T0>& lhs, IO_Rep<T0, T1>& rhs)
{
#if DEBUG_EE
  DEBUGOBJ dummy("OPERATORS", NULL, "|| (O, IO)");
#endif
  
  O_DfeNode<T1>* node = new O_BroadCast<T0, T1>;
  node->left(&lhs);
  node->right(&rhs);

  return *node;
}

//
// Unify IO | IO
//
template <class T0, class T1, class T2>
IO_DfeNode<T0, T2>&
operator || (const IO_DfeNode<T0, T1>& lhs, IO_Rep<T1, T2>& rhs)
{
#if DEBUG_EE
  DEBUGOBJ dummy("OPERATORS", NULL, "|| (IO, IO)");
#endif
  
  IO_DfeNode<T0, T2>* node = new IO_BroadCast<T0, T1, T2>;
  node->left(&lhs);
  node->right(&rhs);

  return *node;
}



