// ------------------------------------------------------------
// Handler for deque commands
//
// Needed to avoid empty-queue deadlock
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------


struct broadcastcreateinfo {
  Command* _command;
  CommandHandler* _handler;
};

void * broadCastHandler(void* arg)
{
  broadcastcreateinfo* c = (broadcastcreateinfo*) arg;

  (c->_command)->Do(*(c->_handler));

  delete c->_command; c->_command = NULL;
  delete c; c = NULL;
  return NULL;
}



//
// Request handler 
//

class BroadCastDequeHandler :
  public DequeHandler
{

public:
  BroadCastDequeHandler(Pqueue<Command*>* queue) :
    DequeHandler(queue)
  {}
  
  virtual void handleRequest()
  {
#if DEBUG_EE
    DEBUGOBJ dummy("BROADCASTHANDLER", this, "handleRequest");
#endif

    try {
      Command* command = NULL;
      while (1) {
	broadcastcreateinfo* c = new broadcastcreateinfo;
	c->_command = _commandqueue->deque();
	c->_handler = this;
	Thread_t t;
	ThreadEngine::instance()->create_local(t, &broadCastHandler, c);
      } 
    } catch (PqueueBase::ExDead& e) {
      // Queue is dead!
    }
  }

  virtual ThreadedHandler* clone()
  {
    return new BroadCastDequeHandler(*this);
  }
};


