// ------------------------------------------------------------
// broadcast Queues
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

//
// Implementation of Local
// of queues
//
template <class T>
class PqueueBroadCastBody : public PqueueBody<T>
{
public:
  PqueueBroadCastBody(int phead, int ptail) :
    PqueueBody<T>(phead, ptail)
  {
#if DEBUG_EE
    DEBUGOBJ dummy("BROADCASTQUEUE", this, "Construction");
#endif     

    CATDEBUG("BROADCASTQUEUE", MSG("BROADCASTQUEUE", this, "TAIL", tail()));

    _cond = new Cond[tail()];

    _readers_to_go = tail();
    _done = FALSE;
  }

  //
  // Clean up
  ~PqueueBroadCastBody()
  {
#if DEBUG_EE
    DEBUGOBJ dummy("BROADCASTQUEUE", this, "Destruction");
#endif 
    delete [] _cond;
  }


  //
  // Deque
  virtual T deque(int who, bool wait = TRUE) // throw (ExDead) 
  {
    // Provide all synchonization 
    Synchronize _with(_broadme);

#if DEBUG_EE
    char str[50];
    sprintf(str, "Deque %i", who);
    DEBUGOBJ dummy("BROADCASTQUEUE", this, str);
#endif 

    if (!wait) {
      if (_cond[who].value()) throw ExEmpty(__FILE__, __LINE__);
    }


    // Have I dequed the current element?
    Wait _while(_cond[who], _broadme);

    // I', reading this one
    _cond[who].value(TRUE, FALSE);
    
    if (_done == TRUE) {
      throw PqueueBase::ExDead(__FILE__, __LINE__);
    }

    if (_readers_to_go == tail()) {

      try {
	_item = PqueueBody<T>::deque(who);
      } catch (PqueueBase::ExDead& e) {
	_done = TRUE;
	throw PqueueBase::ExDead(__FILE__, __LINE__);
      }
    }

    _readers_to_go--;

    if (_readers_to_go == 0) {
      _readers_to_go = tail();
      for (int i = 0; i < tail(); i++) {
	if (i == who) {
	  _cond[i].value(FALSE, FALSE);
	} else {
	  _cond[i].value(FALSE);
	}
      }
    };

    return _item;
  }

private:
  Mutex _broadme;
  Cond* _cond;
  T _item;
  bool _done;
  int _readers_to_go;
};








