// ------------------------------------------------------------
// Channel
//
// Interface Definition for Channels
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

//
// Interface definition for channels
//
class Channel 
{
public:
  // Don't return until size bytes have been sent
  virtual void send(const void* data, size_t size) = 0;
  // Don't return until size bytes are received
  virtual void receive(void* data, size_t size) = 0;


  // Channel are full-duplex
  // So they need protection both ways
  Mutex* send_mutex() {
    return &_s;
  }
  Mutex* recv_mutex() {
    return &_r;
  }
  
private:
  Mutex _s;
  Mutex _r;
};

