// ------------------------------------------------------------
// Handler for Channels
//
// This handler takes elements from a Command Queue and 
// Executes them on availabilty
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

class CommandHandler :
  public ThreadedHandler
{
public:
  CommandHandler(Pqueue<Command*>* queue) :
    _commandqueue(queue)
  {}

  virtual void handleRequest()
  {
#if DEBUG_EE
    DEBUGOBJ dummy("COMMANDHANDLER", this, "handleRequest");
#endif

    try {
      Command* command = NULL;
      while (1) {
	command = _commandqueue->deque();
	command->Do(*this);
	delete command; command = NULL;
      } 
    } catch (PqueueBase::ExDead& e) {
      // Queue is dead!
    }
  }
  
  virtual ThreadedHandler* clone() {
    return new CommandHandler(*this);
  }

  Pqueue<Command*>* queue() {
    return _commandqueue;
  }

protected:
  Pqueue<Command*>* _commandqueue;
};


