// ------------------------------------------------------------
// Comunication engine singleton
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

class CommunicationEngine : //@<CommEngine>
  public Singleton
{
public:  
  void connect(int port)
  {
    Synchronize _with(_me);
#if DEBUG_EE
    DEBUGOBJ dummy("COMMENGINE", this, "Connect");
#endif

    _port = port;
    ProcMap* map = ProcMap::instance();

    // First setup local channel
    Channel* l = new LocalChannel;
    map->channel(_whoami, l);

      // Create local handlers
    PqueueChannel* localchannel = new PqueueChannel(l);
    Handler* localhandler = new CommandHandler(localchannel);
    localhandler->handle();

    CTicBack tic;
    *l << tic;
    
    for (int i = _whoami+1; i < map->num(); i++) {
      // Set local entry
      Socket* s = new Socket(map->proc(i), port);
      
      map->channel(i, s);

      // Create local handlers
      PqueueChannel* channel = new PqueueChannel(s);
      Handler* handler = new CommandHandler(channel);
      handler->handle();
      
      // set remote entry
      CInit init(_whoami);
      *s << init;
    }
  }

  //
  // Stop remote servers
  //
  void stopServers()
  {
    CStop stop;
    for (int i = ProcMap::instance()->num()-1; i > 0; i--) {
      Channel* s = new Socket(ProcMap::instance()->proc(i), _port);
      //      *s << stop >> reply; !!!!!!!!!!!!!!!!!!!!!!!!!!!
    }
  }

  // Get id of host process
  void me(proc_t whoami)
  {
    Synchronize _with(_me);
#if DEBUG_EE
    DEBUGOBJ dummy("COMMENGINE", this, "Setting Me");
#endif

    _whoami = whoami;
    _howmany = (ProcMap::instance()->num() - _whoami);
    _init.value(_howmany);
  }

  proc_t me()
  {
    Synchronize _with(_me);
#if DEBUG_EE
    DEBUGOBJ dummy("COMMENGINE", this, "Getting Me");
#endif
    
    return _whoami;
  }

  //
  // Wait until initialization is done
  //
  void waitUntilInit()
  {
    Wait _for(_init);
  }


  // Allow command to access local mutex and cond.
  friend class CInit;
  friend class CTicBack;

protected:
  CommunicationEngine() :
    _port(0),
    _whoami(0),
    _init(0),
    _howmany(0)
  {
#if DEBUG_EE
    DEBUGOBJ dummy("COMMENGINE", this, "Constructor");
#endif
  }

  virtual ~CommunicationEngine()
  {}
  
  void tic()
  {
    Synchronize _with(_me);
#if DEBUG_EE
    DEBUGOBJ dummy("COMMENGINE", this, "Tic");
#endif
   
    _init.reset();
  };
  


private:
  int _port;
  proc_t _whoami;
  int _howmany;
  Semaphore _init;

public:
  static CommunicationEngine* instance()
  {
    if (_instance == 0) {
      Synchronize _with(_me);
      if (_instance == 0) {
        _instance = new CommunicationEngine;
	_singletonmanager.add(_instance, SingletonManager::dontcare);
      }
    }
    return _instance;
  }

private:
  static CommunicationEngine* _instance;
  static Mutex _me;
};

// Initialization
CommunicationEngine* CommunicationEngine::_instance = 0;
Mutex CommunicationEngine::_me;






