// ------------------------------------------------------------
// CommandWithReply
//
// Mauricio De Simone
// mdesimon@interlog.com
///
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

class CommandWithReply :
  public Command
{
public:
  CommandWithReply() :
    _return(FALSE),
    _cleanup(FALSE),
    _m(new Mutex),
    _c(new Cond(TRUE))
  {
    _place = this;
  }

  // If destroying on sender side
  // cleanup
  ~CommandWithReply()
  {
    if (_cleanup == TRUE) {
      delete _m; _m = NULL;
      delete _c; _c = NULL;
    }
  }

  //
  // Interface for children
  //
  virtual void wakeupaction()
  {}
  virtual void operate(CommandHandler& /* handler */)
  {}
  virtual void reply(CommandHandler& /* handler */)
  {}
  
  //
  // Command entry point
  //
  virtual void Do(CommandHandler& handler)
  {
#if DEBUG_EE
    DEBUGOBJ dummy("COMMREPLY", this, "Do");
#endif
    
    // Perform operations on one end
    if (_return == FALSE) {
      operate(handler);
      _return = TRUE;

      // Send reply
      handler.queue()->enque(this);
    } else {
      // Another
      reply(handler);
      back();
      _return = FALSE;
    }
  }

  //
  // Wait for reply on sender side
  void wait()
  {
    Synchronize _with(*_m);
    Wait _while(*_c, *_m);
    _c->value(TRUE); //
    _return = FALSE; // allow object reuse
    _cleanup = TRUE;
    wakeupaction();
  };

  //
  // Update memory image when back
  void back()
  {
    Synchronize _with(*_m);
    memcpy(_place, this /*&_data*/, size() /*sizof(_data)*/);
    _c->value(FALSE);
  }


  
  virtual size_t size() {
    return sizeof(*this);
  }
  
  virtual CommandWithReply* clone() = 0;
  
protected:
  bool _cleanup;
  bool _return;
  Mutex* _m;
  Cond* _c;
  Command* _place;
};







