// --------------------------------------------------
// Concurrent Execute
//
// mauricio De Simone
// mdeimone@uwaterloo.ca
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// --------------------------------------------------

//
// Concurrent Excecute Container
// Base class
//
class ConcExec :
  public DfeOpnode
{
public:
  //
  // Instantiate
  virtual void instantiate(DfeNode& /* parent */, AeHandle& handle)
  {
#if DISTMEM
    if (_right->where() == ProcBinding::whereever) {
      _right->where(ProcBinding::instance()->where());
    }
#endif
    DfeNode::instantiate(*this, handle);
  }

#if DISTMEM
  //
  // Where
  virtual proc_t where() {
    return _where;
  }
  virtual void where(proc_t where) {
    _where = where;
  }
#endif

  void source(PqueueLocator& loc) {
    loc.tail(2);
    left()->source(loc);
    right()->source(loc);
  }

  // Set sink
  void sink(PqueueLocator& loc) {
    loc.head(2);
    left()->sink(loc);
    right()->sink(loc);
  }

protected:
  int _num;
#if DISTMEM
  proc_t _where;
#endif
};

//
// Closed replication
//
class C_ConcExec :
  public ConcExec,
  public C_DfeOpnode
{};

//
// Input replication
//
template <class T_IN>
class I_ConcExec :
  public ConcExec,
  public I_DfeOpnode<T_IN>
{};

//
// Output Replication
//
template <class T_OUT>
class O_ConcExec :
  public ConcExec,
  public O_DfeOpnode<T_OUT>
{};

//
// Input/Output ConcExeclication
//
template <class T_IN, class T_OUT>
class IO_ConcExec :
  public ConcExec,
  public IO_DfeOpnode<T_IN, T_OUT>
{};


// --------------------------------------------------
// ConcExec operator
// --------------------------------------------------

C_ConcExec&
operator / (const C_DfeNode& lhs, const C_DfeNode& rhs)
{
#if DEBUG_EE
  DEBUGOBJ dummy("OPERATORS", NULL, "/ (C, C)");
#endif

  C_ConcExec* node = new C_ConcExec;
  node->left(&lhs);
  node->right(&rhs);
  return *node;
}

template <class T>
I_ConcExec<T>&
operator / (const I_DfeNode<T>& lhs, const I_DfeNode<T>& rhs)
{
#if DEBUG_EE
  DEBUGOBJ dummy("OPERATORS", NULL, "/ (I, I)");
#endif

  I_ConcExec<T>* node = new I_ConcExec<T>;
  node->left(&lhs);
  node->right(&rhs);
  return *node;
}

template <class T>
O_ConcExec<T>&
operator / (const O_DfeNode<T>& lhs, const O_DfeNode<T>& rhs)
{
#if DEBUG_EE
  DEBUGOBJ dummy("OPERATORS", NULL, "/ (O, O)");
#endif

  O_ConcExec<T>* node = new O_ConcExec<T>;
  node->left(&lhs);
  node->right(&rhs);
  return *node;
}

template <class T, class V>
IO_ConcExec<T, V>&
operator / (const IO_DfeNode<T, V>& lhs, const IO_DfeNode<T, V>& rhs)
{
#if DEBUG_EE
  DEBUGOBJ dummy("OPERATORS", NULL, "/ (IO, IO)");
#endif

  IO_ConcExec<T, V>* node = new IO_ConcExec<T, V>;
  node->left(&lhs);
  node->right(&rhs);
  return *node;
}
