// ------------------------------------------------------------
// 
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

//
// Command to create queue in remote machine
//

template <class T>
class CreateRemoteQueue :
  public CommandWithReply
{
public:
  CreateRemoteQueue(int head, int tail, int broadcast) :
    _broadcast(broadcast),
    _head(head),
    _tail(tail)
  {}
  
  virtual void operate(CommandHandler& /* handler */)
  {
    _command = new PqueueBody<Command*>;

    if (_broadcast) {
      _data = new PqueueBroadCastBody<T>(_head, _tail);
      _dequehandler = new BroadCastDequeHandler(_command);
    } else {
      _data = new PqueueBody<T>(_head);
      _dequehandler = new DequeHandler(_command);

    }

    _dequehandler->handle();
  }

  virtual void reply(CommandHandler& /* handler */)
  {}

  virtual Pqueue<T>* data_queue() {
    return _data;
  }
  virtual Pqueue<Command*>* command_queue() {
    return _command;
  }

  virtual DequeHandler* dequehandler() {
    return _dequehandler;
  }
  
  virtual size_t size() {
    return sizeof(*this);
  }

  virtual CommandWithReply* clone() {
    return new CreateRemoteQueue<T>(*this);
  }

protected:
  Pqueue<T>* _data;
  Pqueue<Command*>* _command;
  DequeHandler* _dequehandler;
  int _head;
  int _tail;
  int _broadcast;
};


