// ------------------------------------------------------------
// 
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

//
// Parameter passign struct
//

struct CreateThreadInfoLocal
{
  void* (*method)(void*);
  void* arg;
};

#if DISTMEM

class CreateThreadInfoRemote :
  public Streamable
{
public:
  CreateThreadInfoRemote() :
    method(NULL),
    arg(NULL)
  {}
  
  void* (*method)(void*);
  Sizeable* arg;


  virtual size_t size() {
    return sizeof(*this);
  }
  
  virtual void pickle(Channel& channel) 
  {
    int size;
    channel.send(&method, sizeof(method));
    if (arg != NULL) {
      size = arg->size();
      channel.send(&size, sizeof(size));
      channel.send(arg, size);
    } else {
      size = -1;
      channel.send(&size, sizeof(size));
    }
  }

  virtual void depickle(Channel& channel)
  {
    int size;
    channel.receive(&method, sizeof(method));
    channel.receive(&size, sizeof(size));
    if (size != -1) {
      arg = (Sizeable*) new char[size];
      channel.receive(arg, size);
    }
  }
};

#endif


