// ------------------------------------------------------------
// Cycle
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

template <class T_OUT>
class Cycle :
  public C_we
{
public:
  Cycle(IO_DfeNode<T_OUT, T_OUT>& node, const Unary_Op<bool, T_OUT>& op) :
    _op(&op),
    _node(&node)
  {}

  virtual void execute()
  {
#if DEBUG_EE
    DEBUGOBJ dummy("CYCLE", this, "execute");
#endif
    
    // Instantiate node
    IO_AeHandle<T_OUT, T_OUT> h = *_node;
    
    T_OUT out;
    while (h >> out) {
      if (_op->operator()(out)) {
	h << out;
      } 
    }
  }

  virtual We* clone() {
    return new Cycle<T_OUT>(*this);
  }

  virtual size_t size() {
    return sizeof(*this);
  }

protected:
  IO_DfeNode<T_OUT, T_OUT>* _node;
  const Unary_Op<bool, T_OUT>* _op;
};

//
// Spare the user from having to specify
// explictly the types involved
//




template <class T_OUT>
Cycle<T_OUT>&
cycle(IO_DfeNode<T_OUT, T_OUT>& node, const Unary_Op<bool, T_OUT>& op)
{
  return *new Cycle<T_OUT>(node, op);
}




