// ------------------------------------------------------------
// Debug Helpers
//
// Stream Debug Messages
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

template <class T0>
void DEBUGMSG(const T0& DEBUGARG(arg0))
{
#if DEBUG
  Synchronize _with(IO_Mutex);
  cout << arg0 << endl;
#endif
}

template <class T0, class T1>
void DEBUGMSG(const T0& DEBUGARG(arg0), const T1& DEBUGARG(arg1))
{
#if DEBUG
  Synchronize _with(IO_Mutex);
  cout << arg0 << " : " << arg1 << endl;
#endif
}

template <class T0, class T1, class T2>
void DEBUGMSG(const T0& DEBUGARG(arg0), const T1& DEBUGARG(arg1), 
	      const T2& DEBUGARG(arg2))
{
#if DEBUG
  Synchronize _with(IO_Mutex);
  cout << arg0 << " : " << arg1
       << " : " << arg2 << endl;
#endif
}

template <class T0, class T1, class T2, class T3>
void DEBUGMSG(const T0& DEBUGARG(arg0), const T1& DEBUGARG(arg1),
	      const T2& DEBUGARG(arg2), const T3& DEBUGARG(arg3))
{
#if DEBUG
  Synchronize _with(IO_Mutex);
  cout << arg0 << " : " << arg1
       << " : " << arg2 << " : " << arg3 << endl;
#endif
}

template <class T0, class T1, class T2, class T3, class T4>
void DEBUGMSG(const T0& DEBUGARG(arg0), const T1& DEBUGARG(arg1),
	      const T2& DEBUGARG(arg2), const T3& DEBUGARG(arg3), 
	      const T4& DEBUGARG(arg4))
{
#if DEBUG
  Synchronize _with(IO_Mutex);
  cout << arg0 << " : " << arg1
       << " : " << arg2 << " : " << arg3 << " : " << arg4 << endl;
#endif
}


//
// Debug entry-exit
// Print message on construction and destruction
// Useful when using exceptions
//

DEBUGOBJ::DEBUGOBJ(const char* cat, const void* who, const char* message) :
  _message(message),
  _ptr(who),
  _cat(cat)
{
  if ((DebugState::instance()->display(_cat)) == TRUE) {
    DEBUGMSG("-->", _cat, _ptr, _message);
  }
}

DEBUGOBJ::~DEBUGOBJ()
{
  if ((DebugState::instance()->display(_cat)) == TRUE) {
    DEBUGMSG(" <-", _cat, _ptr, _message);
  }
}



