// ------------------------------------------------------------
// DEBUGOBJ
// Debug object to flag entry/exit of scope
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

//
// Debug entry-exit
// Print message on construction and destruction
//

class DEBUGOBJ
{
public:
  // I wish I had templated member functions :-(
  DEBUGOBJ(const char* cat, const void* who, const char* message);
  ~DEBUGOBJ();

private:
  const char* _message;
  const void* _ptr;
  const char* _cat;
};

//
// Debug message depending of category
//

#define CATDEBUG(cat, command) \
        if ((DebugState::instance()->display(cat)) == TRUE) { command; }



