// ------------------------------------------------------------
// DebugState
// Class implementation
//
// Singleton to keep global debug state
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

//
// Display
// Query validity of display request
//

bool
DebugState::display(const char* cat)
{
  Synchronize _with(_me);
  for (int i = 0; i < MAX_DEBUG_CATEGORY; i++) {
    if (strcmp(cat, _name[i]) == 0) {
      return _state[i];
    }
  }
  return FALSE;
}


//
// Constructor
// Read from file
//

DebugState::DebugState() 
{
  ifstream file("debug.conf");
  for (int i = 0; i < MAX_DEBUG_CATEGORY; i++) {
    if (!file.eof()) {
      file >> _name[i];
      file >> _state[i];
    } else {
      _state[i] = FALSE;
      _name[i][0] = NULL;
    }
  }
}


//
// Singleton stuff
//

DebugState* DebugState::instance()
{
  if (_instance == 0) {
    // Make sure no race condition are around
    Synchronize _with(_me);
    if (_instance == 0) {
      _instance = new DebugState;
      _singletonmanager.add(_instance, SingletonManager::dontcare);
    }
  }
  return _instance;
}

// Initialization
DebugState* DebugState::_instance = 0;
Mutex DebugState::_me;
