// ------------------------------------------------------------
// DebugState
//
// Singleton to keep global debug state
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

class DebugState :
  public Singleton
{
public:

  // Query the display status for a given category
  bool display(const char* cat);
  
protected:
  DebugState();

private:
  char _name[MAX_DEBUG_CATEGORY][MAX_DEBUG_CATEGORY_NAME];
  bool _state[MAX_DEBUG_CATEGORY];
  
public:
  // Singleton support
  static DebugState* instance();

private:
  static DebugState* _instance;
  static Mutex _me;
};

