// ------------------------------------------------------------
// Stream interfaces
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------


//
// Pickle for built in types
//
void
depickle(Channel& channel, char& arg) {
  size_t size;
  channel.receive(&size, sizeof(size_t));
  channel.receive(&arg, sizeof(arg));
}
void
depickle(Channel& channel, unsigned char& arg) {
  size_t size;
  channel.receive(&size, sizeof(size_t));
  channel.receive(&arg, sizeof(arg));
}
void
depickle(Channel& channel, signed char& arg) {
  size_t size;
  channel.receive(&size, sizeof(size_t));
  channel.receive(&arg, sizeof(arg));
}
void
depickle(Channel& channel, short int& arg) {
  size_t size;
  channel.receive(&size, sizeof(size_t));
  channel.receive(&arg, sizeof(arg));
}
void
depickle(Channel& channel, int& arg) {
  size_t size;
  channel.receive(&size, sizeof(size_t));
  channel.receive(&arg, sizeof(arg));
}
void
depickle(Channel& channel, long int& arg) {
  size_t size;
  channel.receive(&size, sizeof(size_t));
  channel.receive(&arg, sizeof(arg));
}
void
depickle(Channel& channel, float& arg) {
  size_t size;
  channel.receive(&size, sizeof(size_t));
  channel.receive(&arg, sizeof(arg));
}
void
depickle(Channel& channel, double& arg) {
  size_t size;
  channel.receive(&size, sizeof(size_t));
  channel.receive(&arg, sizeof(arg));
}
void
depickle(Channel& channel, long double& arg) {
  size_t size;
  channel.receive(&size, sizeof(size_t));
  channel.receive(&arg, sizeof(arg));
}


//
//
// 

template <class T>
void
depickle(Channel& channel, T& arg) {
  arg.depickle(channel);
}




#if 0

//
// Pickle for built in types POINTER
//
void
depickle(Channel& channel, char* arg) {
  size_t size;
  channel.receive(&size, sizeof(size_t));
  channel.receive(&arg, sizeof(arg));
}
void
depickle(Channel& channel, unsigned char* arg) {
  size_t size;
  channel.receive(&size, sizeof(size_t));
  channel.receive(&arg, sizeof(arg));
}
void
depickle(Channel& channel, signed char* arg) {
  size_t size;
  channel.receive(&size, sizeof(size_t));
  channel.receive(&arg, sizeof(arg));
}
void
depickle(Channel& channel, short int* arg) {
  size_t size;
  channel.receive(&size, sizeof(size_t));
  channel.receive(&arg, sizeof(arg));
}
void
depickle(Channel& channel, int* arg) {
  size_t size;
  channel.receive(&size, sizeof(size_t));
  channel.receive(&arg, sizeof(arg));
}
void
depickle(Channel& channel, long int* arg) {
  size_t size;
  channel.receive(&size, sizeof(size_t));
  channel.receive(&arg, sizeof(arg));
}
void
depickle(Channel& channel, float* arg) {
  size_t size;
  channel.receive(&size, sizeof(size_t));
  channel.receive(&arg, sizeof(arg));
}
void
depickle(Channel& channel, double* arg) {
  size_t size;
  channel.receive(&size, sizeof(size_t));
  channel.receive(&arg, sizeof(arg));
}
void
depickle(Channel& channel, long double* arg) {
  size_t size;
  channel.receive(&size, sizeof(size_t));
  channel.receive(&arg, sizeof(arg));
}


//
//
// 

template <class T>
void
depickle(Channel& channel, T* arg) {
  arg->depickle(channel);
}


#endif
