// ------------------------------------------------------------
// 
// mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

//
// Deque
//
template <class T>
class Deque :
  public CommandWithReply
{
public:
  Deque(Pqueue<T>* queue, Pqueue<Command*>* dequequeue, int who) :
    _dequequeue(dequequeue),
    _queue(queue),
    _queuedead(FALSE),
    _enqued(FALSE),
    _who(who)
  {
    _from = CommunicationEngine::instance()->me();
  }

  void arg(const T& param) {
    _data = param;
  }

  T arg() {
    return _data;
  }

  virtual void Do(CommandHandler& handler)
  {
#if DEBUG_EE
    DEBUGOBJ dummy("DEQUE", this, "Command Do");
#endif

    // Perform operations on one end
    if (_return == FALSE) {
      if (_enqued == FALSE) {
        // Create thread to handle request
        _enqued = TRUE;
        _dequequeue->enque(this->clone());
      } else {
        operate(handler);
        _return = TRUE;
        *(ProcMap::instance()->channel(_from)) << *this;
      }
    } else {
      // Another
      reply(handler);
      ::depickle(*((PqueueChannel*)handler.queue())->channel(), _data);
      back();
      _return = FALSE;
    }
  }

  virtual void operate(CommandHandler& /* handler */)
  {
#if DEBUG_EE
    DEBUGOBJ dummy("DEQUE", this, "Operate");
#endif
    try {
      arg(_queue->deque(_who));
    } catch(PqueueBase::ExDead& ex) {
      _queuedead = TRUE;
    }
  }
  
  virtual void wakeupaction()
  {
#if DEBUG_EE
    DEBUGOBJ dummy("DEQUE", this, "Wakeup");
#endif
    if (_queuedead == TRUE) {
      throw PqueueBase::ExDead(__FILE__, __LINE__);
    }
  }

  virtual void pickle(Channel& channel) 
  {
#if DEBUG_EE
    DEBUGOBJ dummy("PICKLE", this, "DEQUE channelOut");
#endif

    // Allow internal to stream an image of this
    Streamable::pickle(channel);

    if (_return == TRUE) {
      // Allow data to stream itself
      ::pickle(channel, _data);
    }
  }


  virtual size_t size() {
    return sizeof(*this);
  }

  virtual CommandWithReply* clone() {
    return new Deque<T>(*this);
  }

private:
  bool _queuedead;
  bool _enqued;
  Pqueue<T>* _queue;
  Pqueue<Command*>* _dequequeue;
  T _data;
  proc_t _from;
  int _who;
};

