// --------------------------------------------------
// Handles for Ptnodes
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// --------------------------------------------------

//
// Parse tree Handles 
//
class DfeHandle :
  virtual public DfeNode
{
public:
  DfeHandle(DfeNode* node) :
    _node(node)
  {
    _left = _node->left();
    _right = _node->right();
  }

  //
  // Forward request
  virtual void instantiate(DfeNode& parent, AeHandle& handle)  {
    _node->instantiate(parent, handle);
  }

#if DISTMEM
  //
  // Where
  virtual proc_t where() {
    return _node->where();
  }
  virtual void where(proc_t where) {
    _node->where(where);
  }
#endif

  //
  // Set source and Sink
  virtual void source(PqueueLocator& queue) {
    _node->source(queue);
  };
  virtual void sink(PqueueLocator& queue) {
    _node->sink(queue);
  };

  virtual int num() {
    return _node->num();
  }
  virtual void num(int num) {
    _node->num(num);
  }

protected:
  DfeNode* _node;
};

//
// Closed
//
class C_DfeHandle :
  public DfeHandle,
  public C_DfeNode
{
public:
  C_DfeHandle(C_DfeNode& arg) :
    DfeHandle(&arg)
  {}
};

//
// Input
//
template <class T_IN>
class I_DfeHandle :
  public DfeHandle,
  public I_DfeNode<T_IN>
{
public:
  I_DfeHandle(I_DfeNode<T_IN>& arg) :
    DfeHandle(&arg)
  {}
};

//
// Output
//
template <class T_OUT>
class O_DfeHandle :
  public DfeHandle,
  public O_DfeNode<T_OUT>
{
public:
  O_DfeHandle(O_DfeNode<T_OUT>& arg) :
    DfeHandle(&arg)
  {}
};

//
// Input / Output
//
template <class T_IN, class T_OUT>
class IO_DfeHandle :
  public DfeHandle,
  public IO_DfeNode<T_IN, T_OUT>
{
public:
  IO_DfeHandle(IO_DfeNode<T_IN, T_OUT>& arg) :
    DfeHandle(&arg)
  {}
};






