// --------------------------------------------------
// Nodes in Dataflow Expresions Parse Tree
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// --------------------------------------------------

//
// -- Parse tree nodes base class
//

class DfeNode 
{
public:

  //
  // Exceptions
  //

  class ExLocatorSet :
    public Exception
  {
  public:
    ExLocatorSet(char* file, int line) :
      Exception(file, line)
    {}
    virtual void print(ostream& os) const {
      os << "Setting locator on a non-leaf node";
    }
  };

  class ExWhere :
    public Exception
  {
  public:
    ExWhere(char* file, int line) :
      Exception(file, line)
    {}
    virtual void print(ostream& os) const {
      os << "Manipulating where on a non-leaf node";
    }
  };

  class ExNum :
    public Exception
  {
  public:
    ExNum(char* file, int line) :
      Exception(file, line)
    {}
    virtual void print(ostream& os) const {
      os << "Manipulating num on a non-leaf node";
    }
  };

  //
  // Members
  //
  
  DfeNode() :
    _left(NULL),
    _right(NULL)
  {}

  //
  // Set source and Sink
  virtual void source(PqueueLocator& /* loc */)
  {
    // Throw exception
    // since this function cannot be called if not
    // defined in operators or worker nodes
    throw ExLocatorSet(__FILE__, __LINE__);
  }
  virtual void sink(PqueueLocator& /* loc */) 
  {
    // Throw exception
    // since this function cannot be called if not
    // defined in operators or worker nodes
    throw ExLocatorSet(__FILE__, __LINE__);
  }

#if DISTMEM
  //
  // Where
  virtual proc_t where() {
    throw ExWhere(__FILE__, __LINE__);
  }
  virtual void where(proc_t /* where */) {
    throw ExWhere(__FILE__, __LINE__);
  }
#endif

  
  //
  // Get/Set left and right nodes
  DfeNode* left()  {
    return _left;
  } 
  DfeNode* right() {
    return _right;
  } 
  virtual void left(const DfeNode* left) {
    _left = (DfeNode*) left;
  }
  virtual void right(const DfeNode* right) {
    _right = (DfeNode*) right;
  }


  virtual int getIdInGroup() {
    return 0;
  }

  //
  // Number in the replication
  virtual int num() {
    return 1;
  }
  
  virtual void num(int /* num */) {
    throw ExNum(__FILE__, __LINE__);
  }


  //
  // The following functions traverse and instantiate the tree
  // instantiate is the entry point
  // called by machinery 
  //

  //
  // Instantiation entry point
  // default behavior
  virtual void instantiate(DfeNode& /* parent */, AeHandle& handle)
  {
#if DEBUG_EE
    DEBUGOBJ dummy("TRAVERSE", this, "Traverse");
#endif

    // traverse descendants
    if (_left != NULL) 
      _left->instantiate(*this, handle);

    if (_right != NULL)
      _right->instantiate(*this, handle);

  }    

protected:
  // Dfe stuff
  DfeNode* _left;
  DfeNode* _right;
};

//
// Closed Dfe Expresion Node
//
class C_DfeNode :
  virtual public DfeNode
{};

//
// Input
//
template <class T_IN>
class I_DfeNode :
  virtual public DfeNode
{};

//
// Output
//
template <class T_OUT>
class O_DfeNode :
  virtual public DfeNode
{};

//
// Input / Output
//
template <class T_IN, class T_OUT>
class IO_DfeNode :
  virtual public DfeNode
{};






