// --------------------------------------------------
// Base class for operators in Dataflow Expresions
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// --------------------------------------------------

//
//  Base class
//
class DfeOpnode :
  virtual public DfeNode
{};

//
// Closed operator
//
class C_DfeOpnode :
  public DfeOpnode,
  virtual public C_DfeNode
{};

//
// Input Operator
//
template <class T_IN>
class I_DfeOpnode :
  public DfeOpnode,
  virtual public I_DfeNode<T_IN>
{};

//
// Output Operator
//
template <class T_OUT>
class O_DfeOpnode :
  public DfeOpnode,
  virtual public O_DfeNode<T_OUT>
{};

//
// Input/Output Operator
//
template <class T_IN, class T_OUT>
class IO_DfeOpnode :
  public DfeOpnode,
  virtual public IO_DfeNode<T_IN, T_OUT>
{};



