// ------------------------------------------------------------
// 
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------


//
// Enque
//
template <class T>
class Enque :
  public Command
{
public:
  Enque(Pqueue<T>* queue, const T& arg) :
    _queue(queue),
    _data((T*)&arg)
  {}

  T arg() {
    return *_data;
  }

  virtual void Do(CommandHandler& handler)
  {
#if DEBUG_EE
    DEBUGOBJ dummy("ENQUE", this, "Command Do");
#endif
    // Get Dat from stream
    Pqueue<T>::Holder* holder = _queue->gimmeHolder();
    ::depickle(*((PqueueChannel*)handler.queue())->channel(), holder->element());
    _queue->enqueHolder(holder);
  }
  
  virtual size_t size() {
    return sizeof(*this);
  }

  virtual void pickle(Channel& channel) 
  {
#if DEBUG_EE
    DEBUGOBJ dummy("PICKLE", this, "pickle");
#endif

    // Allow internal to stream an image of this
    Streamable::pickle(channel);

    // Allow data to stream itself
    ::pickle(channel, *_data);
  }

private:
  Pqueue<T>* _queue;
  T* _data;
};

