// --------------------------------------------------
// Exception
// Class Implementation
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// --------------------------------------------------

//
// Constructor
//

Exception::Exception(const char* file, int line) :
  _file(file),
  _line(line)
{}


//
// Internal show called by operator <<
//

void
Exception::show(ostream& os) const
{
#if DEBUG
  CATDEBUG("EXCEPTION",
           Synchronize _with(IO_Mutex);
           os << "Exception:" << _file << ":" << _line << ":";
           os << _thread._t << ":";
           print(os);
           os << endl;
          )
#endif
}


//
// Set thread exception
//

void
Exception::thread(Thread_t t)
{
  _thread = t;
}
  


