// ------------------------------------------------------------
// Exception
// Class signature
//
// Base class for all exceptions.
// Common stream functionality.
//
// Mauricio De Simone
// mdesimon@interlog.com
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

class Exception
{
public:
  Exception(const char* file, int line);

  // output for derived classes
  virtual void print(ostream& os) const = 0;
  // Set exception thread
  void thread(Thread_t t);
  
protected:
  // Entry point for operator <<
  void show(ostream& os) const;
  friend ostream& operator << (ostream&, const Exception&);

private:
  const char*  _file;
  int          _line;
  Thread_t     _thread;
};


//
// Stream "feel" for exceptions objects
//
ostream&
operator << (ostream& os, const Exception& ex)
{
  ex.show(os);
  return os;
};


