// ------------------------------------------------------------
// Exception Safe thread entry point
// Mauricio De Simonedone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

//
// Entry point to all threads catch exception
//
extern "C" void*
ExceptionSafeThreadEntryPoint(void* arg)
{
  void* ret;
  CreateThreadInfoLocal* info = (CreateThreadInfoLocal*) arg;

#if DEBUG_EE
  DEBUGOBJ dummy("EXSAFEEP", NULL, "Thread Creation");
#endif
  
  sigset_t newset;
  sigemptyset(&newset);
  ThreadEngine::instance()->setsigmask(&newset);


  try {
    ret = info->method(info->arg);
  } catch(Exception& e) {
    // Complement exception with thread information
    e.thread(ThreadEngine::instance()->self());
    //    CATDEBUG("EXCEPTION",  cerr << e);
    cerr << e;
  }

  delete info; info = NULL;
  return ret;
}
